/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.monitor;

import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.monitor.AbstractMonitorLock;
import si.nevensrok.common.monitor.LockStatus;

public class DatabaseMonitorLock
extends AbstractMonitorLock
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DatabaseMonitorLock.class);
    private Connection connection = null;
    private String driver;
    private String url;
    private String username;
    private String password;
    private String table;
    private String machineName = null;
    private boolean clearOnStartup = false;
    private boolean closed = false;

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    public void setClearOnStartup(boolean clearOnStartup) {
        this.clearOnStartup = clearOnStartup;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.clearOnStartup) {
            try {
                Connection connection = this.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement("delete from " + this.table);
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (Exception e) {
                log.error("Error clearing locks", (Throwable)e);
                this.disconnect();
            }
        }
    }

    public void destroy() throws Exception {
        this.closed = true;
        this.disconnect();
    }

    @Override
    public synchronized boolean addLock(String monitor, Date lockDeadline) {
        try {
            Connection connection = this.getConnection();
            String machineIp4 = null;
            String machineIp6 = null;
            String machineHostname = null;
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            try {
                machineHostname = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                log.error("Error fetching hostname", (Throwable)e);
            }
            try {
                Enumeration<NetworkInterface> networkInterfaceEnumerator = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaceEnumerator.hasMoreElements()) {
                    NetworkInterface networkInterface = networkInterfaceEnumerator.nextElement();
                    if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual()) continue;
                    Enumeration<InetAddress> addressEnumerator = networkInterface.getInetAddresses();
                    while (addressEnumerator.hasMoreElements()) {
                        InetAddress address = addressEnumerator.nextElement();
                        if (address instanceof Inet4Address) {
                            Inet4Address inet4Address = (Inet4Address)address;
                            machineIp4 = inet4Address.getHostAddress();
                            continue;
                        }
                        if (!(address instanceof Inet6Address)) continue;
                        Inet6Address inet6Address = (Inet6Address)address;
                        machineIp6 = inet6Address.getHostAddress();
                    }
                }
            }
            catch (Exception e) {
                log.error("Error fetching IP addresses", (Throwable)e);
            }
            PreparedStatement preparedStatement = connection.prepareStatement("insert into " + this.table + " (MonitorName,LockDeadline,CreatedAt,MachineIp4,MachineIp6,MachineHostname,MachineName,ProcessName) values (?,?,?,?,?,?,?,?)");
            preparedStatement.setString(1, monitor);
            if (lockDeadline != null) {
                preparedStatement.setTimestamp(2, new Timestamp(lockDeadline.getTime()));
            } else {
                preparedStatement.setTimestamp(2, null);
            }
            preparedStatement.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            preparedStatement.setString(4, machineIp4);
            preparedStatement.setString(5, machineIp6);
            preparedStatement.setString(6, machineHostname);
            preparedStatement.setString(7, this.machineName);
            preparedStatement.setString(8, processName);
            boolean added = false;
            try {
                preparedStatement.executeUpdate();
                added = true;
            }
            catch (SQLException e) {
                if (this.isDuplicateKeyException(e)) {
                    added = false;
                }
                throw e;
            }
            preparedStatement.close();
            return added;
        }
        catch (Exception e) {
            log.error("Error adding lock", (Throwable)e);
            this.disconnect();
            return false;
        }
    }

    @Override
    public synchronized void removeLock(String monitor) {
        try {
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("delete from " + this.table + " where MonitorName=?");
            preparedStatement.setString(1, monitor);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (Exception e) {
            log.error("Error removing lock", (Throwable)e);
            this.disconnect();
        }
    }

    @Override
    public synchronized void removeExpiredLocks() {
        try {
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("delete from " + this.table + " where LockDeadline<?");
            preparedStatement.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (Exception e) {
            log.error("Error removing expired locks", (Throwable)e);
            this.disconnect();
        }
    }

    @Override
    public synchronized LockStatus getLockStatus(String monitor) {
        try {
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("select LockDeadline from " + this.table + " where MonitorName=?");
            preparedStatement.setString(1, monitor);
            ResultSet resultSet = preparedStatement.executeQuery();
            LockStatus lockStatus = null;
            if (resultSet.next()) {
                lockStatus = new LockStatus(resultSet.getDate(1));
            }
            preparedStatement.close();
            return lockStatus;
        }
        catch (Exception e) {
            log.error("Error fetching lock status", (Throwable)e);
            this.disconnect();
            return null;
        }
    }

    private Connection getConnection() {
        if (this.closed) {
            return null;
        }
        if (this.connection == null) {
            try {
                Class.forName(this.driver);
                this.connection = DriverManager.getConnection(this.url, this.username, this.password);
            }
            catch (Exception e) {
                log.error("Error opening connection", (Throwable)e);
            }
        }
        return this.connection;
    }

    private void disconnect() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection = null;
    }

    private boolean isDuplicateKeyException(SQLException e) {
        return this.driver.equalsIgnoreCase("org.postgresql.Driver") && e.getMessage().indexOf("duplicate key value violates unique constraint") >= 0;
    }
}

