/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.fightinfo.gui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.springframework.context.ApplicationContext;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.fightinfo.common.FightWindowData;

public class FightLineInfo
extends JPanel {
    private static final long serialVersionUID = -6931854924491054340L;
    private Tatami tatami;
    private JLabel tatamiNameLabel = new JLabel();
    private JCheckBox displayWindowCheckbox = new JCheckBox();
    private JTextField positionXTextField = new JTextField("0");
    private JTextField positionYTextField = new JTextField("0");
    private JTextField widthTextField = new JTextField("600");
    private JTextField heightTextField = new JTextField("40");
    private JTextField fontSizeTextField = new JTextField("12");
    private JCheckBox flipSidesCheckbox = new JCheckBox();

    public FightLineInfo(final ApplicationContext applicationContext, final Locale locale, final Tatami tatami) {
        this.tatami = tatami;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FightLineInfo.this.setLayout(new FlowLayout(0));
                FightLineInfo.this.setMinimumSize(new Dimension(300, 30));
                FightLineInfo.this.tatamiNameLabel.setPreferredSize(new Dimension(140, 20));
                FightLineInfo.this.tatamiNameLabel.setText(tatami.getName());
                FightLineInfo.this.add(FightLineInfo.this.tatamiNameLabel);
                FightLineInfo.this.add(new JLabel("  |  "));
                FightLineInfo.this.displayWindowCheckbox.setText(applicationContext.getMessage("fightInfo.displayFightData", null, locale));
                FightLineInfo.this.add(FightLineInfo.this.displayWindowCheckbox);
                FightLineInfo.this.add(new JLabel("  |  "));
                FightLineInfo.this.add(new JLabel(applicationContext.getMessage("fightInfo.position", null, locale)));
                FightLineInfo.this.positionXTextField.setPreferredSize(new Dimension(60, 20));
                FightLineInfo.this.add(FightLineInfo.this.positionXTextField);
                FightLineInfo.this.add(new JLabel("x"));
                FightLineInfo.this.positionYTextField.setPreferredSize(new Dimension(60, 20));
                FightLineInfo.this.add(FightLineInfo.this.positionYTextField);
                FightLineInfo.this.add(new JLabel("  |  "));
                FightLineInfo.this.add(new JLabel(applicationContext.getMessage("fightInfo.size", null, locale)));
                FightLineInfo.this.widthTextField.setPreferredSize(new Dimension(60, 20));
                FightLineInfo.this.add(FightLineInfo.this.widthTextField);
                FightLineInfo.this.add(new JLabel("x"));
                FightLineInfo.this.heightTextField.setPreferredSize(new Dimension(60, 20));
                FightLineInfo.this.add(FightLineInfo.this.heightTextField);
                FightLineInfo.this.add(new JLabel("  |  "));
                FightLineInfo.this.add(new JLabel(applicationContext.getMessage("fightInfo.fontSize", null, locale)));
                FightLineInfo.this.fontSizeTextField.setPreferredSize(new Dimension(40, 20));
                FightLineInfo.this.add(FightLineInfo.this.fontSizeTextField);
                FightLineInfo.this.add(new JLabel("  |  "));
                FightLineInfo.this.flipSidesCheckbox.setText(applicationContext.getMessage("fightInfo.flipSides", null, locale));
                FightLineInfo.this.add(FightLineInfo.this.flipSidesCheckbox);
                FightLineInfo.this.revalidate();
                FightLineInfo.this.repaint();
            }
        });
    }

    public Tatami getTatami() {
        return this.tatami;
    }

    public void updateData(final Tatami tatami) {
        this.tatami = tatami;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FightLineInfo.this.tatamiNameLabel.setText(tatami.getName());
            }
        });
    }

    public FightWindowData getFightWindowData() {
        FightWindowData fightWindowData = new FightWindowData();
        fightWindowData.setTatami(this.tatami);
        fightWindowData.setDisplayWindow(this.displayWindowCheckbox.isSelected());
        fightWindowData.setLocation(new Dimension(FightLineInfo.parseInteger(this.positionXTextField.getText()), FightLineInfo.parseInteger(this.positionYTextField.getText())));
        fightWindowData.setSize(new Dimension(FightLineInfo.parseInteger(this.widthTextField.getText()), FightLineInfo.parseInteger(this.heightTextField.getText())));
        fightWindowData.setFontSize(FightLineInfo.parseInteger(this.fontSizeTextField.getText()));
        fightWindowData.setFlipSides(this.flipSidesCheckbox.isSelected());
        return fightWindowData;
    }

    private static int parseInteger(String text) {
        try {
            return Integer.parseInt(text);
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

