/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache.redis;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import si.nevensrok.common.cache.AbstractCache;
import si.nevensrok.common.cache.CacheSettings;
import si.nevensrok.common.cache.CachedValue;
import si.nevensrok.common.utils.ObjectUtil;

public class RedisCache
extends AbstractCache {
    private static final Logger log = LoggerFactory.getLogger(RedisCache.class);
    private static final Charset CHARSET = Charset.forName("UTF8");
    private Jedis jedis;
    private String namePrefix;

    public RedisCache(String name, CacheSettings cacheSettings, Jedis jedis, String namePrefix) {
        super(name, cacheSettings);
        this.jedis = jedis;
        this.namePrefix = namePrefix;
    }

    @Override
    public CachedValue get(Object key) {
        byte[] keyBytes = this.generateKeyBytes(key);
        byte[] cachedBytes = this.jedis.get(keyBytes);
        if (cachedBytes != null) {
            CachedValue cachedValue = (CachedValue)ObjectUtil.deserializeObject((byte[])cachedBytes);
            if (!this.isCacheValid(cachedValue)) {
                cachedValue = null;
            }
            return cachedValue;
        }
        return null;
    }

    public void put(Object key, Object value) {
        try {
            byte[] keyBytes = this.generateKeyBytes(key);
            CachedValue cachedValue = new CachedValue(value, this.generateValidUntil());
            byte[] cachedBytes = ObjectUtil.serializeObject((Object)cachedValue);
            log.trace("Adding value to cache: {}", (Object)cachedValue);
            Integer expireSeconds = this.generateExpireInSeconds();
            if (expireSeconds != null) {
                this.jedis.setex(keyBytes, expireSeconds.intValue(), cachedBytes);
            } else {
                this.jedis.set(keyBytes, cachedBytes);
            }
        }
        catch (Throwable e) {
            log.error("Error adding cache", e);
        }
    }

    public void evict(Object key) {
        try {
            byte[] keyBytes = this.generateKeyBytes(key);
            this.jedis.del(keyBytes);
        }
        catch (Throwable e) {
            log.error("Error evicting cache", e);
        }
    }

    public void clear() {
        try {
            Set keySet = this.jedis.keys(this.generateKeyPattern());
            for (byte[] keyBytes : keySet) {
                this.jedis.del(keyBytes);
            }
        }
        catch (Throwable e) {
            log.error("Error clearing cache", e);
        }
    }

    private byte[] generateKeyPattern() {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            buffer.write(this.namePrefix.getBytes(CHARSET));
            buffer.write((this.getName() + ".*").getBytes(CHARSET));
            return buffer.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating key pattern", e);
        }
    }

    protected byte[] generateKeyBytes(Object key) {
        try {
            if (key == null) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(this.namePrefix.getBytes(CHARSET));
                buffer.write((this.getName() + ".null").getBytes(CHARSET));
                return buffer.toByteArray();
            }
            if (key instanceof Boolean) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(this.namePrefix.getBytes(CHARSET));
                buffer.write((this.getName() + ".O").getBytes(CHARSET));
                buffer.write(key.toString().getBytes(CHARSET));
                return buffer.toByteArray();
            }
            if (key instanceof Byte) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(this.namePrefix.getBytes(CHARSET));
                buffer.write((this.getName() + ".B").getBytes(CHARSET));
                buffer.write(key.toString().getBytes(CHARSET));
                return buffer.toByteArray();
            }
            if (key instanceof Short) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(this.namePrefix.getBytes(CHARSET));
                buffer.write((this.getName() + ".H").getBytes(CHARSET));
                buffer.write(key.toString().getBytes(CHARSET));
                return buffer.toByteArray();
            }
            if (key instanceof Integer) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(this.namePrefix.getBytes(CHARSET));
                buffer.write((this.getName() + ".I").getBytes(CHARSET));
                buffer.write(key.toString().getBytes(CHARSET));
                return buffer.toByteArray();
            }
            if (key instanceof Long) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(this.namePrefix.getBytes(CHARSET));
                buffer.write((this.getName() + ".L").getBytes(CHARSET));
                buffer.write(key.toString().getBytes(CHARSET));
                return buffer.toByteArray();
            }
            if (key instanceof Float) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(this.namePrefix.getBytes(CHARSET));
                buffer.write((this.getName() + ".F").getBytes(CHARSET));
                buffer.write(String.valueOf(Float.floatToIntBits(((Float)key).floatValue())).getBytes(CHARSET));
                return buffer.toByteArray();
            }
            if (key instanceof Double) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(this.namePrefix.getBytes(CHARSET));
                buffer.write((this.getName() + ".D").getBytes(CHARSET));
                buffer.write(String.valueOf(Double.doubleToLongBits((Double)key)).getBytes(CHARSET));
                return buffer.toByteArray();
            }
            if (key instanceof Character) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(this.namePrefix.getBytes(CHARSET));
                buffer.write((this.getName() + ".C").getBytes(CHARSET));
                buffer.write(key.toString().getBytes(CHARSET));
                return buffer.toByteArray();
            }
            if (key instanceof String) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(this.namePrefix.getBytes(CHARSET));
                buffer.write((this.getName() + ".S").getBytes(CHARSET));
                buffer.write(key.toString().getBytes(CHARSET));
                return buffer.toByteArray();
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            buffer.write(this.namePrefix.getBytes(CHARSET));
            buffer.write((this.getName() + ".").getBytes(CHARSET));
            buffer.write(ObjectUtil.serializeObject((Object)key));
            return buffer.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating key bytes", e);
        }
    }

    protected Integer generateExpireInSeconds() {
        Long ttl = this.getCacheSettings().getTimeToLive();
        if (ttl != null) {
            return (int)Math.ceil(ttl.doubleValue() / 1000.0);
        }
        return null;
    }
}

