/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.TablaWindow;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class ChallengeDialog
extends JDialog
implements ApplicationContextAware {
    private static final long serialVersionUID = 3165815747662485040L;
    private static final Font TEXT_FONT = new Font("Serif", 1, 120);
    private TablaWindow tablaWindow;
    private MatchData matchData;
    private ApplicationContext applicationContext;
    private TablaManager tablaManager;
    private JPanel competitor1panel = new JPanel();
    private JLabel competitor1label = new JLabel();
    private JLabel competitor1wonLabel = new JLabel();
    private JLabel competitor1lostLabel = new JLabel();
    private JPanel competitor2panel = new JPanel();
    private JLabel competitor2label = new JLabel();
    private JLabel competitor2wonLabel = new JLabel();
    private JLabel competitor2lostLabel = new JLabel();

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ChallengeDialog(TablaWindow tablaWindow) {
        super((Window)tablaWindow, Dialog.ModalityType.APPLICATION_MODAL);
        this.tablaWindow = tablaWindow;
        this.setDefaultCloseOperation(1);
        this.setLayout(new GridLayout(1, 2));
        this.competitor2panel.setBackground(Constants.COMPETITOR_2_BG_COLOR);
        this.competitor2panel.setLayout(new GridLayout(3, 1));
        this.add(this.competitor2panel);
        this.competitor1panel.setBackground(Constants.COMPETITOR_1_BG_COLOR);
        this.competitor1panel.setLayout(new GridLayout(3, 1));
        this.add(this.competitor1panel);
        this.competitor1panel.add(this.competitor1label);
        this.competitor1label.setHorizontalAlignment(0);
        this.competitor1label.setForeground(Constants.COMPETITOR_1_FG_COLOR);
        this.competitor1label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ChallengeDialog.this.matchData.isChallengeAvailable1()) {
                    return;
                }
                if (ChallengeDialog.this.matchData.getChallengesLost1() > 0) {
                    ChallengeDialog.this.competitor1label.setText("");
                    return;
                }
                if (e.getButton() == 1) {
                    ChallengeDialog.this.competitor1label.setText(ChallengeDialog.this.getLanguageText("text.challenge"));
                } else {
                    ChallengeDialog.this.competitor1label.setText("");
                }
                FontSizeUtil.refitFontSize(TEXT_FONT, ChallengeDialog.this.competitor1label);
            }
        });
        this.competitor1panel.add(this.competitor1wonLabel);
        this.competitor1wonLabel.setForeground(Constants.COMPETITOR_1_FG_COLOR);
        this.competitor1wonLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ChallengeDialog.this.matchData.isChallengeAvailable1()) {
                    return;
                }
                if (ChallengeDialog.this.matchData.getChallengesLost1() > 0) {
                    return;
                }
                if (e.getButton() == 1) {
                    ChallengeDialog.this.competitor1label.setText("");
                    ChallengeDialog.this.matchData.setChallengesWon1(ChallengeDialog.this.matchData.getChallengesWon1() + 1);
                } else if (ChallengeDialog.this.matchData.getChallengesWon1() > 0) {
                    ChallengeDialog.this.matchData.setChallengesWon1(ChallengeDialog.this.matchData.getChallengesWon1() - 1);
                }
                ChallengeDialog.this.competitor1wonLabel.setText(ChallengeDialog.this.getLanguageText("text.won") + ": " + ChallengeDialog.this.matchData.getChallengesWon1());
                FontSizeUtil.refitFontSize(TEXT_FONT, ChallengeDialog.this.competitor1wonLabel);
            }
        });
        this.competitor1panel.add(this.competitor1lostLabel);
        this.competitor1lostLabel.setForeground(Constants.COMPETITOR_1_FG_COLOR);
        this.competitor1lostLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ChallengeDialog.this.matchData.isChallengeAvailable1()) {
                    return;
                }
                if (e.getButton() == 1) {
                    if (ChallengeDialog.this.matchData.getChallengesLost1() == 0) {
                        ChallengeDialog.this.competitor1label.setText("");
                        ChallengeDialog.this.matchData.setChallengesLost1(ChallengeDialog.this.matchData.getChallengesLost1() + 1);
                    }
                } else if (ChallengeDialog.this.matchData.getChallengesLost1() > 0) {
                    ChallengeDialog.this.matchData.setChallengesLost1(ChallengeDialog.this.matchData.getChallengesLost1() - 1);
                }
                ChallengeDialog.this.competitor1lostLabel.setText(ChallengeDialog.this.getLanguageText("text.lost") + ": " + ChallengeDialog.this.matchData.getChallengesLost1());
                FontSizeUtil.refitFontSize(TEXT_FONT, ChallengeDialog.this.competitor1lostLabel);
            }
        });
        this.competitor2panel.add(this.competitor2label);
        this.competitor2label.setHorizontalAlignment(0);
        this.competitor2label.setForeground(Constants.COMPETITOR_2_FG_COLOR);
        this.competitor2label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ChallengeDialog.this.matchData.isChallengeAvailable2()) {
                    return;
                }
                if (ChallengeDialog.this.matchData.getChallengesLost2() > 0) {
                    ChallengeDialog.this.competitor2label.setText("");
                    return;
                }
                if (e.getButton() == 1) {
                    ChallengeDialog.this.competitor2label.setText(ChallengeDialog.this.getLanguageText("text.challenge"));
                } else {
                    ChallengeDialog.this.competitor2label.setText("");
                }
                FontSizeUtil.refitFontSize(TEXT_FONT, ChallengeDialog.this.competitor2label);
            }
        });
        this.competitor2panel.add(this.competitor2wonLabel);
        this.competitor2wonLabel.setForeground(Constants.COMPETITOR_2_FG_COLOR);
        this.competitor2wonLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ChallengeDialog.this.matchData.isChallengeAvailable2()) {
                    return;
                }
                if (ChallengeDialog.this.matchData.getChallengesLost2() > 0) {
                    return;
                }
                if (e.getButton() == 1) {
                    ChallengeDialog.this.competitor2label.setText("");
                    ChallengeDialog.this.matchData.setChallengesWon2(ChallengeDialog.this.matchData.getChallengesWon2() + 1);
                } else if (ChallengeDialog.this.matchData.getChallengesWon2() > 0) {
                    ChallengeDialog.this.matchData.setChallengesWon2(ChallengeDialog.this.matchData.getChallengesWon2() - 1);
                }
                ChallengeDialog.this.competitor2wonLabel.setText(ChallengeDialog.this.getLanguageText("text.won") + ": " + ChallengeDialog.this.matchData.getChallengesWon2());
                FontSizeUtil.refitFontSize(TEXT_FONT, ChallengeDialog.this.competitor2wonLabel);
            }
        });
        this.competitor2panel.add(this.competitor2lostLabel);
        this.competitor2lostLabel.setForeground(Constants.COMPETITOR_2_FG_COLOR);
        this.competitor2lostLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ChallengeDialog.this.matchData.isChallengeAvailable2()) {
                    return;
                }
                if (e.getButton() == 1) {
                    if (ChallengeDialog.this.matchData.getChallengesLost2() == 0) {
                        ChallengeDialog.this.competitor2label.setText("");
                        ChallengeDialog.this.matchData.setChallengesLost2(ChallengeDialog.this.matchData.getChallengesLost2() + 1);
                    }
                } else if (ChallengeDialog.this.matchData.getChallengesLost2() > 0) {
                    ChallengeDialog.this.matchData.setChallengesLost2(ChallengeDialog.this.matchData.getChallengesLost2() - 1);
                }
                ChallengeDialog.this.competitor2lostLabel.setText(ChallengeDialog.this.getLanguageText("text.lost") + ": " + ChallengeDialog.this.matchData.getChallengesLost2());
                FontSizeUtil.refitFontSize(TEXT_FONT, ChallengeDialog.this.competitor2lostLabel);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ChallengeDialog.this.redrawElements();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ChallengeDialog.this.matchData.isChallengeAvailable1()) {
                    ChallengeDialog.this.competitor1label.setText("");
                }
                if (ChallengeDialog.this.matchData.isChallengeAvailable2()) {
                    ChallengeDialog.this.competitor2label.setText("");
                }
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            int width = (int)((float)this.tablaWindow.getWidth() * 0.8f);
            int height = (int)((float)this.tablaWindow.getHeight() * 0.6f);
            this.setSize(width, height);
            this.setLocationRelativeTo(this.tablaWindow);
            this.redrawElements();
        }
        super.setVisible(b);
        if (!b) {
            this.tablaManager.recalculatePoints();
        }
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.matchData.getLocale());
    }

    public void resetData() {
        if (!this.matchData.isChallengeAvailable1()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChallengeDialog.this.competitor1label.setText(ChallengeDialog.this.getLanguageText("text.notAvailable"));
                }
            });
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChallengeDialog.this.competitor1label.setText("");
                }
            });
        }
        if (!this.matchData.isChallengeAvailable2()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChallengeDialog.this.competitor2label.setText(ChallengeDialog.this.getLanguageText("text.notAvailable"));
                }
            });
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChallengeDialog.this.competitor2label.setText("");
                }
            });
        }
    }

    private void redrawElements() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChallengeDialog.this.competitor1wonLabel.setText(ChallengeDialog.this.getLanguageText("text.won") + ": " + ChallengeDialog.this.matchData.getChallengesWon1());
                ChallengeDialog.this.competitor1lostLabel.setText(ChallengeDialog.this.getLanguageText("text.lost") + ": " + ChallengeDialog.this.matchData.getChallengesLost1());
                ChallengeDialog.this.competitor2wonLabel.setText(ChallengeDialog.this.getLanguageText("text.won") + ": " + ChallengeDialog.this.matchData.getChallengesWon2());
                ChallengeDialog.this.competitor2lostLabel.setText(ChallengeDialog.this.getLanguageText("text.lost") + ": " + ChallengeDialog.this.matchData.getChallengesLost2());
                FontSizeUtil.refitFontSize(TEXT_FONT, ChallengeDialog.this.competitor1label);
                FontSizeUtil.refitFontSize(TEXT_FONT, ChallengeDialog.this.competitor1wonLabel);
                FontSizeUtil.refitFontSize(TEXT_FONT, ChallengeDialog.this.competitor1lostLabel);
                FontSizeUtil.refitFontSize(TEXT_FONT, ChallengeDialog.this.competitor2label);
                FontSizeUtil.refitFontSize(TEXT_FONT, ChallengeDialog.this.competitor2wonLabel);
                FontSizeUtil.refitFontSize(TEXT_FONT, ChallengeDialog.this.competitor2lostLabel);
                ChallengeDialog.this.invalidate();
                ChallengeDialog.this.revalidate();
                ChallengeDialog.this.repaint();
            }
        });
    }

    public void setShowChallenge1() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChallengeDialog.this.competitor1label.setText(ChallengeDialog.this.getLanguageText("text.challenge"));
                ChallengeDialog.this.setVisible(true);
            }
        });
    }

    public void setShowChallenge2() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChallengeDialog.this.competitor2label.setText(ChallengeDialog.this.getLanguageText("text.challenge"));
                ChallengeDialog.this.setVisible(true);
            }
        });
    }
}

