/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jasypt.util.password.PasswordEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.tatami.Event;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.dl.dao.TatamiDAO;
import si.nevensrok.jtekma.server.management.TatamiHistoryManager;
import si.nevensrok.jtekma.server.management.TatamiManager;
import si.nevensrok.jtekma.services.common.Credentials;

public class TatamiManagerImpl
implements TatamiManager {
    private static final Logger log = LoggerFactory.getLogger(TatamiManagerImpl.class);
    private PasswordEncryptor passwordEncryptor;
    private TatamiDAO tatamiDAO;
    private TatamiHistoryManager tatamiHistoryManager;

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
    }

    public void setTatamiDAO(TatamiDAO tatamiDAO) {
        this.tatamiDAO = tatamiDAO;
    }

    public void setTatamiHistoryManager(TatamiHistoryManager tatamiHistoryManager) {
        this.tatamiHistoryManager = tatamiHistoryManager;
    }

    @Transactional(value="jtekmaTransactionManager")
    public Tatami createTatami(Tatami tatami) {
        tatami.setPassword(this.passwordEncryptor.encryptPassword(tatami.getPassword()));
        log.debug("Creating tatami {}", (Object)tatami);
        return (Tatami)this.tatamiDAO.create((Pojo)tatami);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Tatami createTatamiWithPassword(Tatami tatami) {
        log.debug("Creating tatami {}", (Object)tatami);
        return (Tatami)this.tatamiDAO.create((Pojo)tatami);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Tatami updateTatami(Tatami tatami) {
        log.debug("Updating tatami {}", (Object)tatami);
        return (Tatami)this.tatamiDAO.update((Pojo)tatami);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void updateTatamiPassword(Tatami tatami) {
        tatami.setPassword(this.passwordEncryptor.encryptPassword(tatami.getPassword()));
        log.debug("Updating tatamis password {}", (Object)tatami);
        this.tatamiDAO.updateTatamiPassword(tatami);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void deleteTatami(Tatami tatami) {
        log.debug("Deleting tatami {}", (Object)tatami);
        this.tatamiDAO.setFightOrderForTatami(tatami, new LinkedList());
        this.tatamiDAO.setCategoriesForTatami(tatami, new HashSet());
        this.tatamiHistoryManager.deleteTatamiHistoryForTatami(tatami);
        this.tatamiDAO.delete((Pojo)tatami);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Tatami getById(Long tatamiId) {
        return (Tatami)this.tatamiDAO.getById((Object)tatamiId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public PageDataResult<Tatami> find(Competition competition, DataFilter dataFilter) {
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        rootFilter.addFilter((Filter)new FieldFilter("competition", FieldFilter.Comparator.EQUAL, (Object)competition.getId()));
        rootFilter.addFilter(dataFilter.getFilter());
        ((SimpleDataFilter)dataFilter).setFilter((Filter)rootFilter);
        return this.tatamiDAO.find(dataFilter);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Integer getTatamiCount(Competition competition) {
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new FieldFilter("competition", FieldFilter.Comparator.EQUAL, (Object)competition.getId()));
        dataFilter.setFetchList(false);
        PageDataResult resultPage = this.tatamiDAO.find((DataFilter)dataFilter);
        return resultPage.getTotalCount().intValue();
    }

    @Transactional(value="jtekmaTransactionManager")
    public Tatami getActiveTatamiByName(Competition competition, String name) {
        return this.tatamiDAO.getActiveTatamiByName(competition, name);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setCategoriesForTatami(Tatami tatami, Set<Category> categories) {
        this.tatamiDAO.setCategoriesForTatami(tatami, categories);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Set<Category> getCategoriesForTatami(Tatami tatami) {
        return this.tatamiDAO.getCategoriesForTatami(tatami);
    }

    @Transactional(value="jtekmaTransactionManager")
    public boolean isCategoryOnTatami(Tatami tatami, Category category) {
        return this.tatamiDAO.isCategoryOnTatami(tatami, category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setFightOrderForTatami(Tatami tatami, List<FightOrder> fightOrders) {
        this.tatamiDAO.setFightOrderForTatami(tatami, fightOrders);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<FightOrder> getFightOrderForTatami(Tatami tatami) {
        return this.tatamiDAO.getFightOrderForTatami(tatami, null);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<FightOrder> getFightOrderForTatami(Tatami tatami, int count) {
        return this.tatamiDAO.getFightOrderForTatami(tatami, Integer.valueOf(count));
    }

    @Transactional(value="jtekmaTransactionManager")
    public Tatami getTatamiForEvent(Event event) {
        return this.tatamiDAO.getTatamiForEvent(event);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Tatami getTatamiForMatch(Match match) {
        return this.tatamiDAO.getTatamiForMatch(match);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<Category, Set<Tatami>> getTatamisForCategories(Set<Category> categories) {
        return this.tatamiDAO.getTatamisForCategories(categories);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Tatami getTatamiByCredentials(Credentials credentials) {
        if (credentials.getUsername() == null || credentials.getPassword() == null) {
            return null;
        }
        Tatami tatami = this.tatamiDAO.getTatamiForActiveCompetition(credentials.getUsername());
        if (tatami == null) {
            return null;
        }
        if (this.passwordEncryptor.checkPassword(credentials.getPassword(), tatami.getPassword())) {
            return tatami;
        }
        return null;
    }
}

