/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.security;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import si.nevensrok.jtekma.server.management.RecoverPasswordTokenManager;

public class ExpiredRecoverPasswordTokenRemoverJob
implements Job {
    private Logger log = LoggerFactory.getLogger(ExpiredRecoverPasswordTokenRemoverJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            ApplicationContext applicationContext;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Expired recover password tokens remover job started");
            }
            if ((applicationContext = (ApplicationContext)jobExecutionContext.getScheduler().getContext().get((Object)"applicationContext")) == null) {
                throw new Exception("No application context available");
            }
            RecoverPasswordTokenManager recoverPasswordTokenManager = (RecoverPasswordTokenManager)applicationContext.getBean("jtekmaRecoverPasswordTokenManager");
            if (recoverPasswordTokenManager == null) {
                throw new Exception("RecoverPasswordTokenManager bean not found");
            }
            recoverPasswordTokenManager.removeExpired();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Expired recover password tokens remover job finished");
            }
        }
        catch (Exception e) {
            this.log.error("Error while removeing expired recover password tokens");
        }
    }
}

