/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x509.Certificate;
import si.nevensrok.common.ssl.BcRevokedCertificateChecker;

public class BcMultipleRevokedCertificateChecker
implements BcRevokedCertificateChecker {
    private List<BcRevokedCertificateChecker> checkers = new LinkedList<BcRevokedCertificateChecker>();

    public BcMultipleRevokedCertificateChecker() {
    }

    public BcMultipleRevokedCertificateChecker(List<BcRevokedCertificateChecker> revokedCertificateChecker) {
        this.checkers.addAll(this.checkers);
    }

    public BcMultipleRevokedCertificateChecker(BcRevokedCertificateChecker ... revokedCertificateChecker) {
        for (BcRevokedCertificateChecker r : revokedCertificateChecker) {
            this.checkers.add(r);
        }
    }

    public void addChecker(BcRevokedCertificateChecker ... revokedCertificateChecker) {
        for (BcRevokedCertificateChecker r : revokedCertificateChecker) {
            this.checkers.add(r);
        }
    }

    @Override
    public boolean isCertificateRevoked(Certificate certificate) {
        for (BcRevokedCertificateChecker revokedCertificateChecker : this.checkers) {
            if (!revokedCertificateChecker.isCertificateRevoked(certificate)) continue;
            return true;
        }
        return false;
    }
}

