/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui;

import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;
import si.nevensrok.jtekma.tabla.common.MatchData;

public class SystemInfoDialog
extends JDialog
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoDialog.class);
    private static final long serialVersionUID = 5970412206323460721L;
    private ApplicationContext applicationContext;
    private MatchData matchData;
    private JFrame tablaWindow;
    private JLabel[] labels = new JLabel[4];

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaWindow(JFrame tablaWindow) {
        this.tablaWindow = tablaWindow;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public SystemInfoDialog() {
        this.setAlwaysOnTop(true);
        this.setSize(450, 120);
        this.setResizable(false);
        this.setLayout(new GridLayout(this.labels.length, 1));
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new JLabel();
            this.add(this.labels[i]);
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SystemInfoDialog.this.setVisible(false);
                }
            }
        });
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.matchData.getLocale());
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this.tablaWindow);
            this.setTitle(this.getLanguageText("systemInfo.title"));
            String buildVersion = "";
            String buildRevision = "";
            String buildAt = "";
            String buildBy = "";
            ClassPathResource gitFileResurce = new ClassPathResource("/git.properties");
            if (gitFileResurce.exists()) {
                try {
                    Properties properties = new Properties();
                    properties.load(gitFileResurce.getInputStream());
                    buildVersion = (String)properties.get("git.commit.id.describe");
                    buildRevision = (String)properties.get("git.commit.id");
                    buildAt = (String)properties.get("git.build.time");
                    buildBy = (String)properties.get("git.build.user.name") + " (" + properties.get("git.build.user.email") + ")";
                }
                catch (Exception e) {
                    log.debug("Error reading git build info", (Throwable)e);
                }
            }
            this.labels[0].setText(this.getLanguageText("systemInfo.version") + ": " + buildVersion);
            this.labels[1].setText(this.getLanguageText("systemInfo.revizija") + ": " + buildRevision);
            this.labels[2].setText(this.getLanguageText("systemInfo.buildedAt") + ": " + buildAt);
            this.labels[3].setText(this.getLanguageText("systemInfo.buildedBy") + ": " + buildBy);
        }
        super.setVisible(b);
    }
}

