/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.util.HashMap;
import java.util.Map;
import si.nevensrok.common.utils.PlaceholderValueProvider;

public final class PlaceholderUtil {
    private PlaceholderUtil() {
    }

    public static String replacePlaceHolders(String text, Map<String, String> placeholders, String startPattern) {
        return PlaceholderUtil.replacePlaceHolders(text, placeholders, startPattern, "", false);
    }

    public static String replacePlaceHolders(String text, Map<String, String> placeholders, String startPattern, String endPattern) {
        return PlaceholderUtil.replacePlaceHolders(text, placeholders, startPattern, endPattern, false);
    }

    public static String replacePlaceHolders(String text, Map<String, String> placeholders, String startPattern, String endPattern, final boolean caseSensitive) {
        if (text == null) {
            return null;
        }
        final HashMap<String, String> replacements = new HashMap<String, String>();
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                if (entry.getKey() == null) continue;
                if (caseSensitive) {
                    replacements.put(entry.getKey().trim(), entry.getValue() == null ? "" : entry.getValue().trim());
                    continue;
                }
                replacements.put(entry.getKey().trim().toUpperCase(), entry.getValue() == null ? "" : entry.getValue().trim());
            }
        }
        PlaceholderValueProvider placeholderValueProvider = new PlaceholderValueProvider(){

            @Override
            public String getValue(String placeholder) {
                if (caseSensitive) {
                    return (String)replacements.get(placeholder);
                }
                return (String)replacements.get(placeholder.toUpperCase());
            }
        };
        return PlaceholderUtil.replacePlaceHolders(text, placeholderValueProvider, startPattern, endPattern);
    }

    public static String replacePlaceHolders(String text, PlaceholderValueProvider placeholderValueProvider, String startPattern) {
        return PlaceholderUtil.replacePlaceHolders(text, placeholderValueProvider, startPattern, "");
    }

    public static String replacePlaceHolders(String text, PlaceholderValueProvider placeholderValueProvider, String startPattern, String endPattern) {
        if (text == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(text);
        int startIndex = buffer.indexOf(startPattern);
        while (startIndex >= 0) {
            int endIndex = -1;
            if (endPattern.isEmpty()) {
                endIndex = buffer.indexOf(" ", startIndex + 1);
                if (endIndex < 0) {
                    endIndex = buffer.length();
                }
            } else {
                endIndex = buffer.indexOf(endPattern, startIndex + 1);
            }
            if (endIndex < 0) break;
            String name = buffer.substring(startIndex + startPattern.length(), endIndex);
            String replacment = placeholderValueProvider.getValue(name.trim());
            if (replacment == null) {
                replacment = "";
            }
            buffer.replace(startIndex, endIndex + endPattern.length(), replacment);
            startIndex = buffer.indexOf(startPattern, startIndex + 1);
        }
        return buffer.toString();
    }
}

