/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.systemsettings;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.SelectType;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.common.rules.TreeAdvancmentItem;
import si.nevensrok.jtekma.common.rules.TreeType;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.systemsettings.TreeAdvancmentModel;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/system-settings/tree-advancments"})
@SessionAttributes(value={"treeAdvancmentListFilter"})
public class TreeAdvancmentController
extends CoreController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeAdvancmentController.class);

    public Map<String, String> getTableDraw(Locale locale) {
        LinkedHashMap<String, String> tableDraw = new LinkedHashMap<String, String>();
        for (int i = 1; i <= 5; ++i) {
            tableDraw.put(String.valueOf(i), this.getLanguageText(locale, "treeAdvancment.draw") + " " + String.valueOf(i));
        }
        return tableDraw;
    }

    public Map<String, String> getTreeDraw(Locale locale) {
        LinkedHashMap<String, String> tableDraw = new LinkedHashMap<String, String>();
        for (int i = 1; i <= 64; ++i) {
            tableDraw.put(String.valueOf(i), this.getLanguageText(locale, "treeAdvancment.draw") + " " + String.valueOf(i));
        }
        return tableDraw;
    }

    public Map<String, String> getWinnerTree(Locale locale, int n) {
        LinkedHashMap<String, String> tableDraw = new LinkedHashMap<String, String>();
        for (int i = 1; i <= n; ++i) {
            tableDraw.put(String.valueOf(i), this.getLanguageText(locale, "treeAdvancment.winner") + " " + String.valueOf(i));
        }
        return tableDraw;
    }

    public Map<String, String> getLoserTree(Locale locale, int n) {
        LinkedHashMap<String, String> tableDraw = new LinkedHashMap<String, String>();
        for (int i = 1; i <= n; ++i) {
            tableDraw.put(String.valueOf(-i), this.getLanguageText(locale, "treeAdvancment.loser") + " " + String.valueOf(i));
        }
        return tableDraw;
    }

    public Map<String, String> getLoserAndWinnerTree(Locale locale, int n) {
        int i;
        LinkedHashMap<String, String> tableDraw = new LinkedHashMap<String, String>();
        for (i = 1; i <= n; ++i) {
            tableDraw.put(String.valueOf(i), this.getLanguageText(locale, "treeAdvancment.winner") + " " + String.valueOf(i));
        }
        for (i = 1; i <= n; ++i) {
            tableDraw.put(String.valueOf(-i), this.getLanguageText(locale, "treeAdvancment.loser") + " " + String.valueOf(i));
        }
        return tableDraw;
    }

    private void addFormOptions(Model model, Locale locale) {
        model.addAttribute("tableDraw", this.getTableDraw(locale));
        model.addAttribute("treeDraw", this.getTreeDraw(locale));
        model.addAttribute("winnerRo1", this.getWinnerTree(locale, 32));
        model.addAttribute("winnerRo2", this.getWinnerTree(locale, 16));
        model.addAttribute("winnerRo3", this.getWinnerTree(locale, 8));
        model.addAttribute("winnerRo4", this.getWinnerTree(locale, 4));
        model.addAttribute("winnerRo5", this.getWinnerTree(locale, 2));
        model.addAttribute("loserRo1", this.getLoserTree(locale, 32));
        model.addAttribute("loserRo2", this.getLoserAndWinnerTree(locale, 16));
        model.addAttribute("loserRo3", this.getWinnerTree(locale, 16));
        model.addAttribute("loserRo4", this.getLoserAndWinnerTree(locale, 8));
        model.addAttribute("loserRo5", this.getWinnerTree(locale, 8));
        model.addAttribute("loserRo6", this.getLoserAndWinnerTree(locale, 4));
        model.addAttribute("loserRo7", this.getWinnerTree(locale, 4));
        model.addAttribute("loserRo8", this.getLoserAndWinnerTree(locale, 2));
        model.addAttribute("loserRo9", this.getWinnerTree(locale, 2));
    }

    @ModelAttribute(value="treeAdvancmentsActive")
    public Boolean getTreeAdvancmentsActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="treeAdvancmentListFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @RequestMapping
    public String list(HttpServletRequest request, Model model, @ModelAttribute(value="treeAdvancmentListFilter") SearchFilter searchFilter, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        dataFilter.setFilter((Filter)rootFilter);
        GroupFilter nameFilter = new GroupFilter(GroupFilter.Combine.OR);
        rootFilter.addFilter((Filter)nameFilter);
        nameFilter.addFilter((Filter)new FieldFilter("name", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + searchFilter.getSearch().trim() + "%")));
        GroupFilter statusFilter = new GroupFilter(GroupFilter.Combine.OR);
        rootFilter.addFilter((Filter)statusFilter);
        statusFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)TreeAdvancment.Status.ACTIVE));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        dataFilter.setItemCountPerPage(searchFilter.getShowPerPage().intValue());
        dataFilter.setPage(searchFilter.getPage().intValue());
        PageDataResult dataResult = this.getManagersList().getTreeAdvancmentManager().find((DataFilter)dataFilter);
        model.addAttribute("treeAdvancments", (Object)dataResult.getData());
        model.addAttribute("totalPages", (Object)dataResult.getPageCount(true));
        if (messageCode == 1) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "treeAdvancment.text.added"));
        } else if (messageCode == 2) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "treeAdvancment.text.updated"));
        } else if (messageCode == 3) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "treeAdvancment.text.deleted"));
        }
        return "system-settings/tree-advancment-list";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, Model model, @ModelAttribute(value="treeAdvancment") TreeAdvancmentModel treeAdvancmentModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        this.addFormOptions(model, RequestContextUtils.getLocale((HttpServletRequest)request));
        return "system-settings/tree-advancment-edit";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String addPost(HttpServletRequest request, Model model, @ModelAttribute(value="treeAdvancment") @Valid TreeAdvancmentModel treeAdvancmentModel, BindingResult bindingResult) {
        TreeAdvancmentItem treeAdvancmentItem;
        int i;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Tree advancment add model {}", (Object)treeAdvancmentModel);
        }
        if (bindingResult.hasErrors()) {
            return this.add(request, model, treeAdvancmentModel, bindingResult);
        }
        TreeAdvancment treeAdvancment = new TreeAdvancment();
        treeAdvancment.setName(treeAdvancmentModel.getName());
        treeAdvancment.setCompetition(null);
        treeAdvancment.setTreeAdvancmentItems(new HashSet());
        treeAdvancment.setStatus(TreeAdvancment.Status.ACTIVE);
        for (i = 0; i < 10; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i + 1));
            treeAdvancmentItem.setFromMatch(treeAdvancmentModel.getTable1()[i]);
            treeAdvancmentItem.setSelectType(SelectType.DRAW);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TABLE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i + 1));
            treeAdvancmentItem.setFromMatch(treeAdvancmentModel.getTable2()[i]);
            treeAdvancmentItem.setSelectType(SelectType.DRAW);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TABLE);
        }
        for (i = 0; i < 32; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i + 1));
            treeAdvancmentItem.setFromMatch(treeAdvancmentModel.getDraw1()[i]);
            treeAdvancmentItem.setSelectType(SelectType.DRAW);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i + 1));
            treeAdvancmentItem.setFromMatch(treeAdvancmentModel.getDraw2()[i]);
            treeAdvancmentItem.setSelectType(SelectType.DRAW);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        for (i = 0; i < 16; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i + 33));
            treeAdvancmentItem.setFromMatch(treeAdvancmentModel.getWinner1()[i]);
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i + 33));
            treeAdvancmentItem.setFromMatch(treeAdvancmentModel.getWinner2()[i]);
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        for (i = 16; i < 24; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 16 + 81));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner1()[i] + 32));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 16 + 81));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner2()[i] + 32));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        for (i = 24; i < 28; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 24 + 105));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner1()[i] + 80));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 24 + 105));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner2()[i] + 80));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        for (i = 28; i < 30; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 28 + 117));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner1()[i] + 104));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 28 + 117));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner2()[i] + 104));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        for (i = 30; i < 31; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 30 + 124));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner1()[i] + 116));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 30 + 124));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner2()[i] + 116));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        for (i = 0; i < 16; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i + 49));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(-treeAdvancmentModel.getLoser1()[i].intValue()));
            treeAdvancmentItem.setSelectType(SelectType.LOSER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i + 49));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(-treeAdvancmentModel.getLoser2()[i].intValue()));
            treeAdvancmentItem.setSelectType(SelectType.LOSER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        for (i = 16; i < 32; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 16 + 65));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] > 0 ? treeAdvancmentModel.getLoser1()[i] + 48 : -treeAdvancmentModel.getLoser1()[i].intValue() + 32));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser1()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 16 + 65));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] > 0 ? treeAdvancmentModel.getLoser2()[i] + 48 : -treeAdvancmentModel.getLoser2()[i].intValue() + 32));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser2()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        for (i = 32; i < 40; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 32 + 89));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] + 64));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 32 + 89));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] + 64));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        for (i = 40; i < 48; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 40 + 97));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] > 0 ? treeAdvancmentModel.getLoser1()[i] + 88 : -treeAdvancmentModel.getLoser1()[i].intValue() + 80));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser1()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 40 + 97));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] > 0 ? treeAdvancmentModel.getLoser2()[i] + 88 : -treeAdvancmentModel.getLoser2()[i].intValue() + 80));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser2()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        for (i = 48; i < 52; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 48 + 109));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] + 96));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 48 + 109));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] + 96));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        for (i = 52; i < 56; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 52 + 113));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] > 0 ? treeAdvancmentModel.getLoser1()[i] + 108 : -treeAdvancmentModel.getLoser1()[i].intValue() + 104));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser1()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 52 + 113));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] > 0 ? treeAdvancmentModel.getLoser2()[i] + 108 : -treeAdvancmentModel.getLoser2()[i].intValue() + 104));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser2()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        for (i = 56; i < 58; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 56 + 119));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] + 112));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 56 + 119));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] + 112));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        for (i = 58; i < 60; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 58 + 121));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] > 0 ? treeAdvancmentModel.getLoser1()[i] + 118 : -treeAdvancmentModel.getLoser1()[i].intValue() + 116));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser1()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 58 + 121));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] > 0 ? treeAdvancmentModel.getLoser2()[i] + 118 : -treeAdvancmentModel.getLoser2()[i].intValue() + 116));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser2()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        for (i = 60; i < 61; ++i) {
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 60 + 123));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] + 120));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR1);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
            treeAdvancmentItem = new TreeAdvancmentItem();
            treeAdvancmentItem.setTreeAvancment(treeAdvancment);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
            treeAdvancmentItem.setForMatch(Integer.valueOf(i - 60 + 123));
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] + 120));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem.setCompetitorType(CompetitorType.COMPETITOR2);
            treeAdvancmentItem.setTreeType(TreeType.TREE);
        }
        treeAdvancment = this.getManagersList().getTreeAdvancmentManager().createTreeAvancment(treeAdvancment);
        return "redirect:/system-settings/tree-advancments?messageCode=1";
    }

    @RequestMapping(value={"/edit/{treeAdvancmentId}"}, method={RequestMethod.GET})
    public String edit(HttpServletRequest request, Model model, @PathVariable(value="treeAdvancmentId") Long treeAdvancmentId, @ModelAttribute(value="treeAdvancment") TreeAdvancmentModel treeAdvancmentModel, BindingResult bindingResult) {
        int n;
        Integer[] integerArray;
        TreeAdvancmentItem treeAdvancmentItem;
        int i;
        TreeAdvancment treeAdvancment = this.getManagersList().getTreeAdvancmentManager().getById(treeAdvancmentId);
        treeAdvancmentModel.setName(treeAdvancment.getName());
        for (i = 0; i < 10; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 1, CompetitorType.COMPETITOR1, TreeType.TABLE);
            treeAdvancmentModel.getTable1()[i] = treeAdvancmentItem.getFromMatch();
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 1, CompetitorType.COMPETITOR2, TreeType.TABLE);
            treeAdvancmentModel.getTable2()[i] = treeAdvancmentItem.getFromMatch();
        }
        for (i = 0; i < 32; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 1, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getDraw1()[i] = treeAdvancmentItem.getFromMatch();
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 1, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getDraw2()[i] = treeAdvancmentItem.getFromMatch();
        }
        for (i = 0; i < 16; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 33, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getWinner1()[i] = treeAdvancmentItem.getFromMatch();
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 33, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getWinner2()[i] = treeAdvancmentItem.getFromMatch();
        }
        for (i = 16; i < 24; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 16 + 81, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getWinner1()[i] = treeAdvancmentItem.getFromMatch() - 32;
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 16 + 81, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getWinner2()[i] = treeAdvancmentItem.getFromMatch() - 32;
        }
        for (i = 24; i < 28; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 24 + 105, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getWinner1()[i] = treeAdvancmentItem.getFromMatch() - 80;
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 24 + 105, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getWinner2()[i] = treeAdvancmentItem.getFromMatch() - 80;
        }
        for (i = 28; i < 30; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 28 + 117, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getWinner1()[i] = treeAdvancmentItem.getFromMatch() - 104;
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 28 + 117, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getWinner2()[i] = treeAdvancmentItem.getFromMatch() - 104;
        }
        for (i = 30; i < 31; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 30 + 124, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getWinner1()[i] = treeAdvancmentItem.getFromMatch() - 116;
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 30 + 124, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getWinner2()[i] = treeAdvancmentItem.getFromMatch() - 116;
        }
        for (i = 0; i < 16; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 49, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getLoser1()[i] = -treeAdvancmentItem.getFromMatch().intValue();
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 49, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getLoser2()[i] = -treeAdvancmentItem.getFromMatch().intValue();
        }
        for (i = 16; i < 32; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 16 + 65, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getLoser1()[i] = treeAdvancmentItem.getFromMatch();
            if (treeAdvancmentItem.getSelectType() == SelectType.LOSER) {
                integerArray = treeAdvancmentModel.getLoser1();
                n = i;
                Integer.valueOf(integerArray[n] - 32);
                integerArray = treeAdvancmentModel.getLoser1();
                n = i;
                Integer.valueOf(integerArray[n] * -1);
            } else {
                integerArray = treeAdvancmentModel.getLoser1();
                n = i;
                Integer.valueOf(integerArray[n] - 48);
            }
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 16 + 65, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getLoser2()[i] = treeAdvancmentItem.getFromMatch();
            if (treeAdvancmentItem.getSelectType() == SelectType.LOSER) {
                integerArray = treeAdvancmentModel.getLoser2();
                n = i;
                Integer.valueOf(integerArray[n] - 32);
                integerArray = treeAdvancmentModel.getLoser2();
                n = i;
                Integer.valueOf(integerArray[n] * -1);
                continue;
            }
            integerArray = treeAdvancmentModel.getLoser2();
            n = i;
            Integer.valueOf(integerArray[n] - 48);
        }
        for (i = 32; i < 40; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 32 + 89, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getLoser1()[i] = treeAdvancmentItem.getFromMatch() - 64;
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 32 + 89, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getLoser2()[i] = treeAdvancmentItem.getFromMatch() - 64;
        }
        for (i = 40; i < 48; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 40 + 97, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getLoser1()[i] = treeAdvancmentItem.getFromMatch();
            if (treeAdvancmentItem.getSelectType() == SelectType.LOSER) {
                integerArray = treeAdvancmentModel.getLoser1();
                n = i;
                Integer.valueOf(integerArray[n] - 80);
                integerArray = treeAdvancmentModel.getLoser1();
                n = i;
                Integer.valueOf(integerArray[n] * -1);
            } else {
                integerArray = treeAdvancmentModel.getLoser1();
                n = i;
                Integer.valueOf(integerArray[n] - 88);
            }
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 40 + 97, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getLoser2()[i] = treeAdvancmentItem.getFromMatch();
            if (treeAdvancmentItem.getSelectType() == SelectType.LOSER) {
                integerArray = treeAdvancmentModel.getLoser2();
                n = i;
                Integer.valueOf(integerArray[n] - 80);
                integerArray = treeAdvancmentModel.getLoser2();
                n = i;
                Integer.valueOf(integerArray[n] * -1);
                continue;
            }
            integerArray = treeAdvancmentModel.getLoser2();
            n = i;
            Integer.valueOf(integerArray[n] - 88);
        }
        for (i = 48; i < 52; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 48 + 109, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getLoser1()[i] = treeAdvancmentItem.getFromMatch() - 96;
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 48 + 109, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getLoser2()[i] = treeAdvancmentItem.getFromMatch() - 96;
        }
        for (i = 52; i < 56; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 52 + 113, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getLoser1()[i] = treeAdvancmentItem.getFromMatch();
            if (treeAdvancmentItem.getSelectType() == SelectType.LOSER) {
                integerArray = treeAdvancmentModel.getLoser1();
                n = i;
                Integer.valueOf(integerArray[n] - 104);
                integerArray = treeAdvancmentModel.getLoser1();
                n = i;
                Integer.valueOf(integerArray[n] * -1);
            } else {
                integerArray = treeAdvancmentModel.getLoser1();
                n = i;
                Integer.valueOf(integerArray[n] - 108);
            }
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 52 + 113, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getLoser2()[i] = treeAdvancmentItem.getFromMatch();
            if (treeAdvancmentItem.getSelectType() == SelectType.LOSER) {
                integerArray = treeAdvancmentModel.getLoser2();
                n = i;
                Integer.valueOf(integerArray[n] - 104);
                integerArray = treeAdvancmentModel.getLoser2();
                n = i;
                Integer.valueOf(integerArray[n] * -1);
                continue;
            }
            integerArray = treeAdvancmentModel.getLoser2();
            n = i;
            Integer.valueOf(integerArray[n] - 108);
        }
        for (i = 56; i < 58; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 56 + 119, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getLoser1()[i] = treeAdvancmentItem.getFromMatch() - 112;
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 56 + 119, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getLoser2()[i] = treeAdvancmentItem.getFromMatch() - 112;
        }
        for (i = 58; i < 60; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 58 + 121, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getLoser1()[i] = treeAdvancmentItem.getFromMatch();
            if (treeAdvancmentItem.getSelectType() == SelectType.LOSER) {
                integerArray = treeAdvancmentModel.getLoser1();
                n = i;
                Integer.valueOf(integerArray[n] - 116);
                integerArray = treeAdvancmentModel.getLoser1();
                n = i;
                Integer.valueOf(integerArray[n] * -1);
            } else {
                integerArray = treeAdvancmentModel.getLoser1();
                n = i;
                Integer.valueOf(integerArray[n] - 118);
            }
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 58 + 121, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getLoser2()[i] = treeAdvancmentItem.getFromMatch();
            if (treeAdvancmentItem.getSelectType() == SelectType.LOSER) {
                integerArray = treeAdvancmentModel.getLoser2();
                n = i;
                Integer.valueOf(integerArray[n] - 116);
                integerArray = treeAdvancmentModel.getLoser2();
                n = i;
                Integer.valueOf(integerArray[n] * -1);
                continue;
            }
            integerArray = treeAdvancmentModel.getLoser2();
            n = i;
            Integer.valueOf(integerArray[n] - 118);
        }
        for (i = 60; i < 61; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 60 + 123, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentModel.getLoser1()[i] = treeAdvancmentItem.getFromMatch() - 120;
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 60 + 123, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentModel.getLoser2()[i] = treeAdvancmentItem.getFromMatch() - 120;
        }
        this.addFormOptions(model, RequestContextUtils.getLocale((HttpServletRequest)request));
        return "system-settings/tree-advancment-edit";
    }

    @RequestMapping(value={"/edit/{treeAdvancmentId}"}, method={RequestMethod.POST})
    public String editPost(HttpServletRequest request, Model model, @PathVariable(value="treeAdvancmentId") Long treeAdvancmentId, @ModelAttribute(value="treeAdvancment") @Valid TreeAdvancmentModel treeAdvancmentModel, BindingResult bindingResult) {
        TreeAdvancmentItem treeAdvancmentItem;
        int i;
        if (bindingResult.hasErrors()) {
            return this.edit(request, model, treeAdvancmentId, treeAdvancmentModel, bindingResult);
        }
        TreeAdvancment treeAdvancment = this.getManagersList().getTreeAdvancmentManager().getById(treeAdvancmentId);
        treeAdvancment.setName(treeAdvancmentModel.getName());
        for (i = 0; i < 10; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 1, CompetitorType.COMPETITOR1, TreeType.TABLE);
            treeAdvancmentItem.setFromMatch(treeAdvancmentModel.getTable1()[i]);
            treeAdvancmentItem.setSelectType(SelectType.DRAW);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 1, CompetitorType.COMPETITOR2, TreeType.TABLE);
            treeAdvancmentItem.setFromMatch(treeAdvancmentModel.getTable2()[i]);
            treeAdvancmentItem.setSelectType(SelectType.DRAW);
        }
        for (i = 0; i < 32; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 1, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(treeAdvancmentModel.getDraw1()[i]);
            treeAdvancmentItem.setSelectType(SelectType.DRAW);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 1, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(treeAdvancmentModel.getDraw2()[i]);
            treeAdvancmentItem.setSelectType(SelectType.DRAW);
        }
        for (i = 0; i < 16; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 33, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(treeAdvancmentModel.getWinner1()[i]);
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 33, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(treeAdvancmentModel.getWinner2()[i]);
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
        }
        for (i = 16; i < 24; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 16 + 81, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner1()[i] + 32));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 16 + 81, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner2()[i] + 32));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
        }
        for (i = 24; i < 28; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 24 + 105, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner1()[i] + 80));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 24 + 105, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner2()[i] + 80));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
        }
        for (i = 28; i < 30; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 28 + 117, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner1()[i] + 104));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 28 + 117, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner2()[i] + 104));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
        }
        for (i = 30; i < 31; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 30 + 124, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner1()[i] + 116));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 30 + 124, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getWinner2()[i] + 116));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
        }
        for (i = 0; i < 16; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 49, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(-treeAdvancmentModel.getLoser1()[i].intValue()));
            treeAdvancmentItem.setSelectType(SelectType.LOSER);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i + 49, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(-treeAdvancmentModel.getLoser2()[i].intValue()));
            treeAdvancmentItem.setSelectType(SelectType.LOSER);
        }
        for (i = 16; i < 32; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 16 + 65, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] > 0 ? treeAdvancmentModel.getLoser1()[i] + 48 : -treeAdvancmentModel.getLoser1()[i].intValue() + 32));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser1()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 16 + 65, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] > 0 ? treeAdvancmentModel.getLoser2()[i] + 48 : -treeAdvancmentModel.getLoser2()[i].intValue() + 32));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser2()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
        }
        for (i = 32; i < 40; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 32 + 89, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] + 64));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 32 + 89, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] + 64));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
        }
        for (i = 40; i < 48; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 40 + 97, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] > 0 ? treeAdvancmentModel.getLoser1()[i] + 88 : -treeAdvancmentModel.getLoser1()[i].intValue() + 80));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser1()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 40 + 97, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] > 0 ? treeAdvancmentModel.getLoser2()[i] + 88 : -treeAdvancmentModel.getLoser2()[i].intValue() + 80));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser2()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
        }
        for (i = 48; i < 52; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 48 + 109, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] + 96));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 48 + 109, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] + 96));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
        }
        for (i = 52; i < 56; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 52 + 113, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] > 0 ? treeAdvancmentModel.getLoser1()[i] + 108 : -treeAdvancmentModel.getLoser1()[i].intValue() + 104));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser1()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 52 + 113, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] > 0 ? treeAdvancmentModel.getLoser2()[i] + 108 : -treeAdvancmentModel.getLoser2()[i].intValue() + 104));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser2()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
        }
        for (i = 56; i < 58; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 56 + 119, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] + 112));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 56 + 119, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] + 112));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
        }
        for (i = 58; i < 60; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 58 + 121, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] > 0 ? treeAdvancmentModel.getLoser1()[i] + 118 : -treeAdvancmentModel.getLoser1()[i].intValue() + 116));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser1()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 58 + 121, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] > 0 ? treeAdvancmentModel.getLoser2()[i] + 118 : -treeAdvancmentModel.getLoser2()[i].intValue() + 116));
            treeAdvancmentItem.setSelectType(treeAdvancmentModel.getLoser2()[i] > 0 ? SelectType.WINNER : SelectType.LOSER);
        }
        for (i = 60; i < 61; ++i) {
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 60 + 123, CompetitorType.COMPETITOR1, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser1()[i] + 120));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
            treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(i - 60 + 123, CompetitorType.COMPETITOR2, TreeType.TREE);
            treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentModel.getLoser2()[i] + 120));
            treeAdvancmentItem.setSelectType(SelectType.WINNER);
        }
        this.getManagersList().getTreeAdvancmentManager().updateTreeAvancment(treeAdvancment);
        return "redirect:/system-settings/tree-advancments?messageCode=2";
    }

    @RequestMapping(value={"/delete/{treeAdvancmentId}"})
    public String delete(HttpServletRequest request, Model model, @PathVariable(value="treeAdvancmentId") Long treeAdvancmentId) {
        TreeAdvancment treeAdvancment = this.getManagersList().getTreeAdvancmentManager().getById(treeAdvancmentId);
        treeAdvancment.setStatus(TreeAdvancment.Status.DELETED);
        this.getManagersList().getTreeAdvancmentManager().updateTreeAvancment(treeAdvancment);
        return "redirect:/system-settings/tree-advancments?messageCode=3";
    }
}

