/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.competition;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.reports.ReportData;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.system.CompetitionRole;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiHistory;
import si.nevensrok.jtekma.rules.rules2023.CompetitionRules2023;
import si.nevensrok.jtekma.server.web.common.CommonResponse;
import si.nevensrok.jtekma.server.web.common.competition.AddMatchData;
import si.nevensrok.jtekma.server.web.common.competition.Competition;
import si.nevensrok.jtekma.server.web.common.competition.DuoPoints;
import si.nevensrok.jtekma.server.web.common.competition.Event;
import si.nevensrok.jtekma.server.web.common.competition.FightPoints;
import si.nevensrok.jtekma.server.web.common.competition.Match;
import si.nevensrok.jtekma.server.web.common.competition.NewazaPoints;
import si.nevensrok.jtekma.server.web.common.competition.Placing;
import si.nevensrok.jtekma.server.web.common.competition.SaveDrawRequest;
import si.nevensrok.jtekma.server.web.common.competition.Table;
import si.nevensrok.jtekma.server.web.common.competition.TatamiFight;
import si.nevensrok.jtekma.server.web.common.competition.TatamiHistoryEvent;
import si.nevensrok.jtekma.server.web.common.json.ChartData;
import si.nevensrok.jtekma.server.web.common.json.ReportChartData;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;
import si.nevensrok.jtekma.server.web.tools.CompetitorNameUtil;
import si.nevensrok.jtekma.server.web.tools.MatchPointsUtil;

@Controller
@RequestMapping(value={"/competition/data"})
public class CompetitionDataController
extends CoreController {
    @RequestMapping(value={"/current-competition"}, method={RequestMethod.GET})
    @ResponseBody
    public Competition getCurrentCompetition(HttpServletResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        User user = this.getUserData().getLoginedUser();
        Competition competition = new Competition(this.getUserData().getCompetition());
        competition.setCanManage(false);
        if (user.getIsSuperAdmin() != null && user.getIsSuperAdmin().booleanValue()) {
            competition.setCanManage(true);
        } else {
            CompetitionRole competitionRole = this.getManagersList().getUserManager().getRoleForUser(user, this.getUserData().getCompetition());
            if (competitionRole != null) {
                competition.setCanManage(this.getManagersList().getRightManager().hasRights(competitionRole.getRole(), Right.LEADCOMPETITION));
            }
        }
        return competition;
    }

    @RequestMapping(value={"/category"}, method={RequestMethod.GET})
    @ResponseBody
    public List<si.nevensrok.jtekma.server.web.common.competition.Category> getCategoryList(HttpServletResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Category example = new Category();
        example.setStatus(Category.Status.ACTIVE);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setItemLimit(Integer.valueOf(1000));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        LinkedList<si.nevensrok.jtekma.server.web.common.competition.Category> categories = new LinkedList<si.nevensrok.jtekma.server.web.common.competition.Category>();
        List categoryList = this.getManagersList().getCategoryManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter).getData();
        HashMap showCategoryById = new HashMap();
        for (Map.Entry entry : this.getManagersList().getCategoryManager().getShowCategoryForUser(this.getUserData().getLoginedUser(), new HashSet(categoryList)).entrySet()) {
            showCategoryById.put(((Category)entry.getKey()).getCategoryId(), entry.getValue());
        }
        for (Category category : categoryList) {
            si.nevensrok.jtekma.server.web.common.competition.Category c = new si.nevensrok.jtekma.server.web.common.competition.Category(category);
            c.setShow((Boolean)showCategoryById.get(category.getCategoryId()));
            categories.add(c);
        }
        return categories;
    }

    @RequestMapping(value={"/category/{categoryId}"}, method={RequestMethod.GET})
    @ResponseBody
    public si.nevensrok.jtekma.server.web.common.competition.Category getCategoryById(HttpServletResponse response, @PathVariable(value="categoryId") Long categoryId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Category category = this.getManagersList().getCategoryManager().getById(categoryId);
        if (category != null) {
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            return new si.nevensrok.jtekma.server.web.common.competition.Category(category);
        }
        return null;
    }

    @RequestMapping(value={"/show-category/{categoryId}/{show}"}, method={RequestMethod.GET})
    public void setCategoryById(HttpServletResponse response, @PathVariable(value="categoryId") Long categoryId, @PathVariable(value="show") Boolean show) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Category category = this.getManagersList().getCategoryManager().getById(categoryId);
        if (category != null) {
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            HashMap<Category, Boolean> categories = new HashMap<Category, Boolean>();
            categories.put(category, show);
            this.getManagersList().getCategoryManager().setShowCategoryForUser(this.getUserData().getLoginedUser(), categories);
        }
    }

    @RequestMapping(value={"/competitor"}, method={RequestMethod.GET})
    @ResponseBody
    public List<si.nevensrok.jtekma.server.web.common.competition.Competitor> getCompetitorList(HttpServletResponse response, @RequestParam(value="categoryId") Long categoryId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Category category = new Category();
        category.setCategoryId(categoryId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        HashMap draw = new HashMap();
        for (Map.Entry entry : this.getManagersList().getCategoryManager().getDraw(category).entrySet()) {
            draw.put(((Competitor)entry.getKey()).getCompetitorId(), entry.getValue());
        }
        LinkedList<si.nevensrok.jtekma.server.web.common.competition.Competitor> competitors = new LinkedList<si.nevensrok.jtekma.server.web.common.competition.Competitor>();
        for (Competitor competitor : this.getManagersList().getCompetitorManager().getCompetitorsForCategory(category)) {
            si.nevensrok.jtekma.server.web.common.competition.Competitor c = new si.nevensrok.jtekma.server.web.common.competition.Competitor(competitor);
            c.setDraw((Integer)draw.get(c.getId()));
            competitors.add(c);
        }
        return competitors;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/save-draw"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse saveDraw(HttpServletResponse response, @RequestBody SaveDrawRequest saveDrawRequest) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Category category = this.getManagersList().getCategoryManager().getById(saveDrawRequest.getCategoryId());
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        HashMap<Competitor, Integer> draw = new HashMap<Competitor, Integer>();
        for (SaveDrawRequest.DrawedCompetitor drawedCompetitor : saveDrawRequest.getDraw()) {
            Competitor competitor = new Competitor();
            competitor.setCompetitorId(drawedCompetitor.getCompetitorId());
            draw.put(competitor, drawedCompetitor.getDrawNumber());
        }
        if (category instanceof TreeCategory && saveDrawRequest.getTreeCategoryOptions() != null) {
            if (saveDrawRequest.getTreeCategoryOptions().getTreeType() != null) {
                this.getManagersList().getCategoryManager().setCategoryTreeType((TreeCategory)category, saveDrawRequest.getTreeCategoryOptions().getTreeType());
            }
            if (saveDrawRequest.getTreeCategoryOptions().getRepassageType() != null) {
                this.getManagersList().getCategoryManager().setRepassageType((TreeCategory)category, saveDrawRequest.getTreeCategoryOptions().getRepassageType());
            }
            if (saveDrawRequest.getTreeCategoryOptions().getDouble3rdPlace() != null) {
                this.getManagersList().getCategoryManager().setDouble3rdPlace((TreeCategory)category, saveDrawRequest.getTreeCategoryOptions().getDouble3rdPlace());
            }
            if (saveDrawRequest.getTreeCategoryOptions().getRepassageFromRound() != null) {
                this.getManagersList().getCategoryManager().setRepassageFromRound((TreeCategory)category, saveDrawRequest.getTreeCategoryOptions().getRepassageFromRound());
            }
        }
        this.getManagersList().getCategoryManager().setDraw(category, draw);
        return new CommonResponse(true);
    }

    @RequestMapping(value={"/match"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Match> getMatchList(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="categoryId") Long categoryId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        Category category = this.getManagersList().getCategoryManager().getById(categoryId);
        si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        LinkedList<Match> matches = new LinkedList<Match>();
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        TreeCategory treeCategory = null;
        if (category instanceof TreeCategory) {
            treeCategory = (TreeCategory)category;
        }
        List matchList = this.getManagersList().getMatchManager().getMatchesForCategory(category);
        HashMap matchPoints = new HashMap();
        for (Map.Entry entry : this.getManagersList().getMatchManager().getMatchPointsForMatches(new HashSet(matchList)).entrySet()) {
            matchPoints.put(((si.nevensrok.jtekma.common.matches.Match)entry.getKey()).getMatchId(), entry.getValue());
        }
        for (si.nevensrok.jtekma.common.matches.Match match : matchList) {
            Competitor winner;
            match.setCategory(category);
            Match m = new Match(match);
            if (treeCategory != null) {
                m.setName(this.getTools().getMatchTool().getMatchName(locale, treeCategory, match));
                m.setShortName(this.getTools().getMatchTool().getMatchShortName(treeCategory, match));
                m.setCanRemove(false);
            } else {
                m.setName(this.getLanguageText(locale, "match.matchNum") + " " + String.valueOf(match.getFightNumber()));
                m.setShortName(String.valueOf(match.getFightNumber()));
                m.setCanRemove(true);
            }
            Set points = (Set)matchPoints.get(match.getMatchId());
            m.setPoints1(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points)));
            m.setPoints2(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points)));
            if (match.getStatus() == Match.Status.FINISHED && (winner = competitionRules.getMatchWinner(match, points)) != null) {
                if (m.getCompetitor1() != null) {
                    m.getCompetitor1().setWinner(winner.getCompetitorId().equals(m.getCompetitor1().getId()));
                }
                if (m.getCompetitor2() != null) {
                    m.getCompetitor2().setWinner(winner.getCompetitorId().equals(m.getCompetitor2().getId()));
                }
            }
            matches.add(m);
        }
        return matches;
    }

    @RequestMapping(value={"/match/{matchId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Match getMatchById(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="matchId") Long matchId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getById(matchId);
        if (match != null) {
            Competitor winner;
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            match.setCategory(category);
            si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
            if (competitionRules == null) {
                throw new RuntimeException("CompetitionRules for competition not found");
            }
            TreeCategory treeCategory = null;
            if (category instanceof TreeCategory) {
                treeCategory = (TreeCategory)category;
            }
            Match m = new Match(match);
            if (treeCategory != null) {
                m.setName(this.getTools().getMatchTool().getMatchName(locale, treeCategory, match));
                m.setShortName(this.getTools().getMatchTool().getMatchShortName(treeCategory, match));
            }
            Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
            m.setPoints1(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points)));
            m.setPoints2(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points)));
            if (match.getStatus() == Match.Status.FINISHED && (winner = competitionRules.getMatchWinner(match, points)) != null) {
                if (m.getCompetitor1() != null) {
                    m.getCompetitor1().setWinner(winner.getCompetitorId().equals(m.getCompetitor1().getId()));
                }
                if (m.getCompetitor2() != null) {
                    m.getCompetitor2().setWinner(winner.getCompetitorId().equals(m.getCompetitor2().getId()));
                }
            }
            return m;
        }
        return null;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/add-match"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse addMatch(HttpServletResponse response, @RequestBody AddMatchData addMatchData, @RequestParam(value="categoryId") Long categoryId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Category category = this.getManagersList().getCategoryManager().getById(categoryId);
        si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        if (category.getType() != Category.Type.CUSTOM) {
            throw new RuntimeException("Category type is not custom");
        }
        if (addMatchData.getCompetitor1id() != null && addMatchData.getCompetitor2id() != null && addMatchData.getType() != null) {
            Competitor competitor1 = null;
            Competitor competitor2 = null;
            for (Competitor competitor : this.getManagersList().getCompetitorManager().getCompetitorsForCategory(category)) {
                if (competitor.getCompetitorId().equals(addMatchData.getCompetitor1id())) {
                    competitor1 = competitor;
                }
                if (!competitor.getCompetitorId().equals(addMatchData.getCompetitor2id())) continue;
                competitor2 = competitor;
            }
            if (competitor1 != null || competitor2 != null) {
                si.nevensrok.jtekma.common.matches.Match match = new si.nevensrok.jtekma.common.matches.Match();
                match.setCompetitor1(competitor1);
                match.setCompetitor2(competitor2);
                match.setNoWinner(Boolean.valueOf(false));
                match.setStatus(Match.Status.WAITING);
                match.setType(addMatchData.getType());
                match.setNotNeeded(Boolean.valueOf(false));
                match.setMatchEmpty(Boolean.valueOf(false));
                match = this.getManagersList().getCategoryTreeUpdateManager().addMatch(category, match);
                return new CommonResponse(true);
            }
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/remove-match/{matchId}"})
    @ResponseBody
    public CommonResponse removeMatch(HttpServletResponse response, @PathVariable(value="matchId") Long matchId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getById(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            if (category.getType() != Category.Type.CUSTOM) {
                throw new RuntimeException("Category type is not custom");
            }
            this.getManagersList().getMatchManager().deleteMatch(match);
            return new CommonResponse(true);
        }
        return new CommonResponse(false);
    }

    @RequestMapping(value={"/table"}, method={RequestMethod.GET})
    @ResponseBody
    public Table getTable(HttpServletResponse response, @RequestParam(value="categoryId") Long categoryId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Category category = new Category();
        category.setCategoryId(categoryId);
        si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        si.nevensrok.jtekma.common.rules.Table table = this.getManagersList().getCategoryTreeUpdateManager().getTable(category);
        competitionRules.setPlacingsInTable(table);
        return new Table(table);
    }

    @RequestMapping(value={"/fight-points"}, method={RequestMethod.GET})
    @ResponseBody
    public FightPoints getFightPoints(HttpServletResponse response, @RequestParam(value="matchId") Long matchId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            match.setCategory(category);
            si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
            Match m = new Match(match);
            FightPoints fightPoints = new FightPoints();
            fightPoints.setRules(competitionRules.getName());
            fightPoints.setNoWinner(match.getNoWinner());
            fightPoints.setFinished(match.getStatus() == Match.Status.FINISHED);
            fightPoints.setMatchTime(match.getFightTimeLeft());
            fightPoints.setHosekomiTime(match.getHosekomiTime());
            fightPoints.setInjuryTime1(match.getInjuryTime1());
            fightPoints.setInjuryTime2(match.getInjuryTime2());
            if (m.getCompetitor1() != null) {
                fightPoints.setCompetitor1(m.getCompetitor1().getName());
                fightPoints.setClub1(m.getCompetitor1().getClubName());
            }
            if (m.getCompetitor2() != null) {
                fightPoints.setCompetitor2(m.getCompetitor2().getName());
                fightPoints.setClub2(m.getCompetitor2().getClubName());
            }
            Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
            for (MatchPoint matchPoint : points) {
                if (matchPoint.getCompetitor() == CompetitorType.COMPETITOR1) {
                    if (matchPoint.getPointType() == PointType.WAZARI) {
                        fightPoints.setWazari1(Math.round(matchPoint.getPoints().floatValue()));
                    } else if (matchPoint.getPointType() == PointType.IPPON1) {
                        fightPoints.setIppon1_1(Math.round(matchPoint.getPoints().floatValue()));
                    } else if (matchPoint.getPointType() == PointType.IPPON2) {
                        fightPoints.setIppon1_2(Math.round(matchPoint.getPoints().floatValue()));
                    } else if (matchPoint.getPointType() == PointType.IPPON3) {
                        fightPoints.setIppon1_3(Math.round(matchPoint.getPoints().floatValue()));
                    } else if (matchPoint.getPointType() == PointType.SHIDO) {
                        fightPoints.setShido1(Math.round(matchPoint.getPoints().floatValue()));
                    } else if (matchPoint.getPointType() == PointType.CHUI) {
                        fightPoints.setChui1(Math.round(matchPoint.getPoints().floatValue()));
                    } else if (matchPoint.getPointType() == PointType.HANSOKUMAKE) {
                        fightPoints.setHansokumake1(Math.round(matchPoint.getPoints().floatValue()));
                    }
                    if (competitionRules instanceof CompetitionRules2023) {
                        if (matchPoint.getPointType() == PointType.IPPON1_3P) {
                            fightPoints.setIppon1_1_3p(Math.round(matchPoint.getPoints().floatValue()));
                            continue;
                        }
                        if (matchPoint.getPointType() == PointType.IPPON2_3P) {
                            fightPoints.setIppon1_2_3p(Math.round(matchPoint.getPoints().floatValue()));
                            continue;
                        }
                        if (matchPoint.getPointType() != PointType.IPPON3_3P) continue;
                        fightPoints.setIppon1_3_3p(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() != PointType.IPPON3POINTS) continue;
                    fightPoints.setIppon1_3_3p(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getCompetitor() != CompetitorType.COMPETITOR2) continue;
                if (matchPoint.getPointType() == PointType.WAZARI) {
                    fightPoints.setWazari2(Math.round(matchPoint.getPoints().floatValue()));
                } else if (matchPoint.getPointType() == PointType.IPPON1) {
                    fightPoints.setIppon2_1(Math.round(matchPoint.getPoints().floatValue()));
                } else if (matchPoint.getPointType() == PointType.IPPON2) {
                    fightPoints.setIppon2_2(Math.round(matchPoint.getPoints().floatValue()));
                } else if (matchPoint.getPointType() == PointType.IPPON3) {
                    fightPoints.setIppon2_3(Math.round(matchPoint.getPoints().floatValue()));
                } else if (matchPoint.getPointType() == PointType.SHIDO) {
                    fightPoints.setShido2(Math.round(matchPoint.getPoints().floatValue()));
                } else if (matchPoint.getPointType() == PointType.CHUI) {
                    fightPoints.setChui2(Math.round(matchPoint.getPoints().floatValue()));
                } else if (matchPoint.getPointType() == PointType.HANSOKUMAKE) {
                    fightPoints.setHansokumake2(Math.round(matchPoint.getPoints().floatValue()));
                }
                if (competitionRules instanceof CompetitionRules2023) {
                    if (matchPoint.getPointType() == PointType.IPPON1_3P) {
                        fightPoints.setIppon2_1_3p(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() == PointType.IPPON2_3P) {
                        fightPoints.setIppon2_2_3p(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() != PointType.IPPON3_3P) continue;
                    fightPoints.setIppon2_3_3p(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getPointType() != PointType.IPPON3POINTS) continue;
                fightPoints.setIppon2_3_3p(Math.round(matchPoint.getPoints().floatValue()));
            }
            return fightPoints;
        }
        return null;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/fight-points"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse setFightPoints(HttpServletResponse response, @RequestBody FightPoints fightPoints, @RequestParam(value="matchId") Long matchId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
            Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.WAZARI).setPoints(Float.valueOf(fightPoints.getWazari1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.IPPON1).setPoints(Float.valueOf(fightPoints.getIppon1_1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.IPPON2).setPoints(Float.valueOf(fightPoints.getIppon1_2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.IPPON3).setPoints(Float.valueOf(fightPoints.getIppon1_3().floatValue()));
            if (competitionRules instanceof CompetitionRules2023) {
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.IPPON1_3P).setPoints(Float.valueOf(fightPoints.getIppon1_1_3p().floatValue()));
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.IPPON2_3P).setPoints(Float.valueOf(fightPoints.getIppon1_2_3p().floatValue()));
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.IPPON3_3P).setPoints(Float.valueOf(fightPoints.getIppon1_3_3p().floatValue()));
            } else {
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.IPPON3POINTS).setPoints(Float.valueOf(fightPoints.getIppon1_3_3p().floatValue()));
            }
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.SHIDO).setPoints(Float.valueOf(fightPoints.getShido1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.CHUI).setPoints(Float.valueOf(fightPoints.getChui1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.HANSOKUMAKE).setPoints(Float.valueOf(fightPoints.getHansokumake1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.WAZARI).setPoints(Float.valueOf(fightPoints.getWazari2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.IPPON1).setPoints(Float.valueOf(fightPoints.getIppon2_1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.IPPON2).setPoints(Float.valueOf(fightPoints.getIppon2_2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.IPPON3).setPoints(Float.valueOf(fightPoints.getIppon2_3().floatValue()));
            if (competitionRules instanceof CompetitionRules2023) {
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.IPPON1_3P).setPoints(Float.valueOf(fightPoints.getIppon2_1_3p().floatValue()));
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.IPPON2_3P).setPoints(Float.valueOf(fightPoints.getIppon2_2_3p().floatValue()));
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.IPPON3_3P).setPoints(Float.valueOf(fightPoints.getIppon2_3_3p().floatValue()));
            } else {
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.IPPON3POINTS).setPoints(Float.valueOf(fightPoints.getIppon2_3_3p().floatValue()));
            }
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.SHIDO).setPoints(Float.valueOf(fightPoints.getShido2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.CHUI).setPoints(Float.valueOf(fightPoints.getChui2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.HANSOKUMAKE).setPoints(Float.valueOf(fightPoints.getHansokumake2().floatValue()));
            this.getManagersList().getMatchManager().setMatchPointsForMatch(match, points);
            match.setNoWinner(Boolean.valueOf(Boolean.TRUE.equals(fightPoints.getNoWinner())));
            this.getManagersList().getMatchManager().setNoWinner(match);
            if (fightPoints.getFinished() != null && fightPoints.getFinished().booleanValue()) {
                if (match.getStatus() == Match.Status.WAITING || match.getStatus() == Match.Status.INPROGRESS || match.getStatus() == Match.Status.INQUEUE || match.getStatus() == Match.Status.FINISHED) {
                    this.getManagersList().getMatchManager().setMatchStatus(match, Match.Status.FINISHED);
                }
            } else if (match.getStatus() == Match.Status.WAITING || match.getStatus() == Match.Status.FINISHED) {
                this.getManagersList().getMatchManager().setMatchStatus(match, Match.Status.WAITING);
            }
            if (fightPoints.getMatchTime() != null && fightPoints.getMatchTime() >= 0) {
                match.setFightTimeLeft(fightPoints.getMatchTime());
            } else {
                match.setFightTimeLeft(null);
            }
            this.getManagersList().getMatchManager().setFightTimeLeft(match);
            if (fightPoints.getHosekomiTime() != null && fightPoints.getHosekomiTime() >= 0) {
                match.setHosekomiTime(fightPoints.getHosekomiTime());
            } else {
                match.setHosekomiTime(null);
            }
            this.getManagersList().getMatchManager().setHosekomiTime(match);
            if (fightPoints.getInjuryTime1() != null && fightPoints.getInjuryTime1() >= 0) {
                match.setInjuryTime1(fightPoints.getInjuryTime1());
            } else {
                match.setInjuryTime1(null);
            }
            if (fightPoints.getInjuryTime2() != null && fightPoints.getInjuryTime2() >= 0) {
                match.setInjuryTime2(fightPoints.getInjuryTime2());
            } else {
                match.setInjuryTime2(null);
            }
            this.getManagersList().getMatchManager().setInjuryTime(match);
            return new CommonResponse(true);
        }
        return new CommonResponse(false);
    }

    @RequestMapping(value={"/duo-points"}, method={RequestMethod.GET})
    @ResponseBody
    public DuoPoints getDuoPoints(HttpServletResponse response, @RequestParam(value="matchId") Long matchId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            match.setCategory(category);
            si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            Match m = new Match(match);
            DuoPoints duoPoints = new DuoPoints();
            duoPoints.setNoWinner(match.getNoWinner());
            duoPoints.setFinished(match.getStatus() == Match.Status.FINISHED);
            duoPoints.setInjuryTime1(match.getInjuryTime1());
            duoPoints.setInjuryTime2(match.getInjuryTime2());
            if (m.getCompetitor1() != null) {
                duoPoints.setCompetitor1(m.getCompetitor1().getName());
                duoPoints.setClub1(m.getCompetitor1().getClubName());
            }
            if (m.getCompetitor2() != null) {
                duoPoints.setCompetitor2(m.getCompetitor2().getName());
                duoPoints.setClub2(m.getCompetitor2().getClubName());
            }
            Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
            for (MatchPoint matchPoint : points) {
                if (matchPoint.getPointType() != PointType.JUDGE) continue;
                int round = matchPoint.getRound() - 1;
                int judge = matchPoint.getJudge() - 1;
                if (matchPoint.getCompetitor() == CompetitorType.COMPETITOR1) {
                    duoPoints.getRounds1()[round].getJudges()[judge].setPoints(matchPoint.getPoints());
                    continue;
                }
                if (matchPoint.getCompetitor() != CompetitorType.COMPETITOR2) continue;
                duoPoints.getRounds2()[round].getJudges()[judge].setPoints(matchPoint.getPoints());
            }
            return duoPoints;
        }
        return null;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/duo-points"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse setDuoPoints(HttpServletResponse response, @RequestBody DuoPoints duoPoints, @RequestParam(value="matchId") Long matchId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
            for (int round = 1; round <= 5; ++round) {
                for (int judge = 1; judge <= 5; ++judge) {
                    MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, round, judge).setPoints(duoPoints.getRounds1()[round - 1].getJudges()[judge - 1].getPoints());
                    MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, round, judge).setPoints(duoPoints.getRounds2()[round - 1].getJudges()[judge - 1].getPoints());
                }
            }
            this.getManagersList().getMatchManager().setMatchPointsForMatch(match, points);
            match.setNoWinner(Boolean.valueOf(Boolean.TRUE.equals(duoPoints.getNoWinner())));
            this.getManagersList().getMatchManager().setNoWinner(match);
            if (duoPoints.getFinished() != null && duoPoints.getFinished().booleanValue()) {
                if (match.getStatus() == Match.Status.WAITING || match.getStatus() == Match.Status.INPROGRESS || match.getStatus() == Match.Status.INQUEUE || match.getStatus() == Match.Status.FINISHED) {
                    this.getManagersList().getMatchManager().setMatchStatus(match, Match.Status.FINISHED);
                }
            } else if (match.getStatus() == Match.Status.WAITING || match.getStatus() == Match.Status.FINISHED) {
                this.getManagersList().getMatchManager().setMatchStatus(match, Match.Status.WAITING);
            }
            if (duoPoints.getInjuryTime1() != null && duoPoints.getInjuryTime1() >= 0) {
                match.setInjuryTime1(duoPoints.getInjuryTime1());
            } else {
                match.setInjuryTime1(null);
            }
            if (duoPoints.getInjuryTime2() != null && duoPoints.getInjuryTime2() >= 0) {
                match.setInjuryTime2(duoPoints.getInjuryTime2());
            } else {
                match.setInjuryTime2(null);
            }
            this.getManagersList().getMatchManager().setInjuryTime(match);
            return new CommonResponse(true);
        }
        return new CommonResponse(false);
    }

    @RequestMapping(value={"/newaza-points"}, method={RequestMethod.GET})
    @ResponseBody
    public NewazaPoints getNewazaPoints(HttpServletResponse response, @RequestParam(value="matchId") Long matchId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            match.setCategory(category);
            si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            Match m = new Match(match);
            NewazaPoints newazaPoints = new NewazaPoints();
            newazaPoints.setNoWinner(match.getNoWinner());
            newazaPoints.setFinished(match.getStatus() == Match.Status.FINISHED);
            newazaPoints.setMatchTime(match.getFightTimeLeft());
            newazaPoints.setHosekomiTime(match.getHosekomiTime());
            newazaPoints.setInjuryTime1(match.getInjuryTime1());
            newazaPoints.setInjuryTime2(match.getInjuryTime2());
            if (m.getCompetitor1() != null) {
                newazaPoints.setCompetitor1(m.getCompetitor1().getName());
                newazaPoints.setClub1(m.getCompetitor1().getClubName());
            }
            if (m.getCompetitor2() != null) {
                newazaPoints.setCompetitor2(m.getCompetitor2().getName());
                newazaPoints.setClub2(m.getCompetitor2().getClubName());
            }
            Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
            for (MatchPoint matchPoint : points) {
                if (matchPoint.getCompetitor() == CompetitorType.COMPETITOR1) {
                    if (matchPoint.getPointType() == PointType.POINT2) {
                        newazaPoints.setPoint1_2(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() == PointType.POINT3) {
                        newazaPoints.setPoint1_3(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() == PointType.POINT4) {
                        newazaPoints.setPoint1_4(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() == PointType.POINT100) {
                        newazaPoints.setPoint1_100(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() == PointType.ADVANTAGE) {
                        newazaPoints.setAdvantage1(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() == PointType.PENALTY) {
                        newazaPoints.setPenalty1(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() != PointType.HANSOKUMAKE) continue;
                    newazaPoints.setHansokumake1(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getCompetitor() != CompetitorType.COMPETITOR2) continue;
                if (matchPoint.getPointType() == PointType.POINT2) {
                    newazaPoints.setPoint2_2(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getPointType() == PointType.POINT3) {
                    newazaPoints.setPoint2_3(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getPointType() == PointType.POINT4) {
                    newazaPoints.setPoint2_4(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getPointType() == PointType.POINT100) {
                    newazaPoints.setPoint2_100(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getPointType() == PointType.ADVANTAGE) {
                    newazaPoints.setAdvantage2(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getPointType() == PointType.PENALTY) {
                    newazaPoints.setPenalty2(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getPointType() != PointType.HANSOKUMAKE) continue;
                newazaPoints.setHansokumake2(Math.round(matchPoint.getPoints().floatValue()));
            }
            return newazaPoints;
        }
        return null;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/newaza-points"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse setNewazaPoints(HttpServletResponse response, @RequestBody NewazaPoints newazaPoints, @RequestParam(value="matchId") Long matchId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.POINT2).setPoints(Float.valueOf(newazaPoints.getPoint1_2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.POINT3).setPoints(Float.valueOf(newazaPoints.getPoint1_3().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.POINT4).setPoints(Float.valueOf(newazaPoints.getPoint1_4().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.POINT100).setPoints(Float.valueOf(newazaPoints.getPoint1_100().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.ADVANTAGE).setPoints(Float.valueOf(newazaPoints.getAdvantage1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.PENALTY).setPoints(Float.valueOf(newazaPoints.getPenalty1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.HANSOKUMAKE).setPoints(Float.valueOf(newazaPoints.getHansokumake1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.POINT2).setPoints(Float.valueOf(newazaPoints.getPoint2_2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.POINT3).setPoints(Float.valueOf(newazaPoints.getPoint2_3().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.POINT4).setPoints(Float.valueOf(newazaPoints.getPoint2_4().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.POINT100).setPoints(Float.valueOf(newazaPoints.getPoint2_100().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.ADVANTAGE).setPoints(Float.valueOf(newazaPoints.getAdvantage2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.PENALTY).setPoints(Float.valueOf(newazaPoints.getPenalty2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.HANSOKUMAKE).setPoints(Float.valueOf(newazaPoints.getHansokumake2().floatValue()));
            this.getManagersList().getMatchManager().setMatchPointsForMatch(match, points);
            match.setNoWinner(Boolean.valueOf(Boolean.TRUE.equals(newazaPoints.getNoWinner())));
            this.getManagersList().getMatchManager().setNoWinner(match);
            if (newazaPoints.getFinished() != null && newazaPoints.getFinished().booleanValue()) {
                if (match.getStatus() == Match.Status.WAITING || match.getStatus() == Match.Status.INPROGRESS || match.getStatus() == Match.Status.INQUEUE || match.getStatus() == Match.Status.FINISHED) {
                    this.getManagersList().getMatchManager().setMatchStatus(match, Match.Status.FINISHED);
                }
            } else if (match.getStatus() == Match.Status.WAITING || match.getStatus() == Match.Status.FINISHED) {
                this.getManagersList().getMatchManager().setMatchStatus(match, Match.Status.WAITING);
            }
            if (newazaPoints.getMatchTime() != null && newazaPoints.getMatchTime() >= 0) {
                match.setFightTimeLeft(newazaPoints.getMatchTime());
            } else {
                match.setFightTimeLeft(null);
            }
            this.getManagersList().getMatchManager().setFightTimeLeft(match);
            if (newazaPoints.getHosekomiTime() != null && newazaPoints.getHosekomiTime() >= 0) {
                match.setHosekomiTime(newazaPoints.getHosekomiTime());
            } else {
                match.setHosekomiTime(null);
            }
            this.getManagersList().getMatchManager().setHosekomiTime(match);
            if (newazaPoints.getInjuryTime1() != null && newazaPoints.getInjuryTime1() >= 0) {
                match.setInjuryTime1(newazaPoints.getInjuryTime1());
            } else {
                match.setInjuryTime1(null);
            }
            if (newazaPoints.getInjuryTime2() != null && newazaPoints.getInjuryTime2() >= 0) {
                match.setInjuryTime2(newazaPoints.getInjuryTime2());
            } else {
                match.setInjuryTime2(null);
            }
            this.getManagersList().getMatchManager().setInjuryTime(match);
            return new CommonResponse(true);
        }
        return new CommonResponse(false);
    }

    @RequestMapping(value={"/placings"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Placing> getPlacings(HttpServletResponse response, @RequestParam(value="categoryId") Long categoryId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Category category = new Category();
        category.setCategoryId(categoryId);
        si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        ArrayList<Placing> placings = new ArrayList<Placing>();
        for (Map.Entry entry : this.getManagersList().getCategoryTreeUpdateManager().getPlacings(category).entrySet()) {
            placings.add(new Placing((Integer)entry.getValue(), new si.nevensrok.jtekma.server.web.common.competition.Competitor((Competitor)entry.getKey())));
        }
        Collections.sort(placings, new Comparator<Placing>(){

            @Override
            public int compare(Placing o1, Placing o2) {
                if (o1.getPlace() < o2.getPlace()) {
                    return -1;
                }
                if (o1.getPlace() > o2.getPlace()) {
                    return 1;
                }
                return o1.getCompetitor().getName().compareTo(o2.getCompetitor().getName());
            }
        });
        return placings;
    }

    @RequestMapping(value={"/tatami"}, method={RequestMethod.GET})
    @ResponseBody
    public List<si.nevensrok.jtekma.server.web.common.competition.Tatami> getTatamis(HttpServletResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setItemLimit(Integer.valueOf(1000));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        LinkedList<si.nevensrok.jtekma.server.web.common.competition.Tatami> tatamis = new LinkedList<si.nevensrok.jtekma.server.web.common.competition.Tatami>();
        for (Tatami tatami : this.getManagersList().getTatamiManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter).getData()) {
            tatamis.add(new si.nevensrok.jtekma.server.web.common.competition.Tatami(tatami));
        }
        return tatamis;
    }

    @RequestMapping(value={"/tatami-fights"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TatamiFight> getTatamiFights(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="tatamiId") Long tatamiId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        LinkedList<TatamiFight> tatamiFights = new LinkedList<TatamiFight>();
        for (FightOrder fightOrder : this.getManagersList().getTatamiManager().getFightOrderForTatami(tatami)) {
            si.nevensrok.jtekma.common.matches.Match match = fightOrder.getMatch();
            if (match != null) {
                match = this.getManagersList().getMatchManager().getByIdWithCompetitors(match.getMatchId());
                fightOrder.setMatch(match);
                Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
                match.setCategory(category);
            }
            TatamiFight tatamiFight = new TatamiFight(fightOrder);
            if (match != null) {
                TreeCategory treeCategory = null;
                if (match.getCategory() instanceof TreeCategory) {
                    treeCategory = (TreeCategory)match.getCategory();
                }
                if (treeCategory != null) {
                    tatamiFight.getMatch().setName(this.getTools().getMatchTool().getMatchName(locale, treeCategory, match));
                    tatamiFight.getMatch().setShortName(this.getTools().getMatchTool().getMatchShortName(treeCategory, match));
                }
                Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
                tatamiFight.getMatch().setPoints1(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points)));
                tatamiFight.getMatch().setPoints2(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points)));
            }
            tatamiFights.add(tatamiFight);
        }
        return tatamiFights;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/add-fight-to-tatami/{tatamiId}/{matchId}"})
    @ResponseBody
    public CommonResponse addMatchToTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="matchId") Long matchId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getById(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean added = this.getManagersList().getTatamiFightsManager().addMatchToTatami(match, tatami);
            return new CommonResponse(added);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/remove-fight-to-tatami/{tatamiId}/{matchId}"})
    @ResponseBody
    public CommonResponse removeMatchFromTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="matchId") Long matchId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getById(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean removed = this.getManagersList().getTatamiFightsManager().removeMatchFromTatami(match, tatami);
            return new CommonResponse(removed);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/moveup-fight-tatami/{tatamiId}/{matchId}"})
    @ResponseBody
    public CommonResponse moveUpMatchOnTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="matchId") Long matchId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getById(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean moved = this.getManagersList().getTatamiFightsManager().moveMatchOnTatamiUp(match, tatami);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/movedown-fight-tatami/{tatamiId}/{matchId}"})
    @ResponseBody
    public CommonResponse moveDownMatchOnTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="matchId") Long matchId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getById(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean moved = this.getManagersList().getTatamiFightsManager().moveMatchOnTatamiDown(match, tatami);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/move-fight-tatami/{tatamiId}/{matchId}/{moveToSpot}"})
    @ResponseBody
    public CommonResponse moveMatchCustomOnTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="matchId") Long matchId, @PathVariable(value="moveToSpot") Integer moveToSpot) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getById(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean moved = this.getManagersList().getTatamiFightsManager().moveMatchOnTatamiToSpot(match, tatami, moveToSpot);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }

    @RequestMapping(value={"/event"}, method={RequestMethod.GET})
    @ResponseBody
    public Event getEvent(HttpServletResponse response, @RequestParam(value="eventId") Long eventId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        si.nevensrok.jtekma.common.tatami.Event event = this.getManagersList().getEventManager().getById(eventId);
        if (event != null) {
            Tatami tatami = this.getManagersList().getTatamiManager().getTatamiForEvent(event);
            si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for tataim");
            }
            return new Event(event);
        }
        return null;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/event"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse setEvent(HttpServletResponse response, @RequestBody Event eventData, @RequestParam(value="eventId", required=false) Long eventId, @RequestParam(value="tatamiId", required=false) Long tatamiId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        if (eventId == null && tatamiId != null) {
            Tatami tatami = this.getManagersList().getTatamiManager().getById(tatamiId);
            si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for tataim");
            }
            si.nevensrok.jtekma.common.tatami.Event event = new si.nevensrok.jtekma.common.tatami.Event();
            event.setText(eventData.getText());
            event.setAutoRemove(eventData.getAutoRemove());
            boolean added = this.getManagersList().getTatamiFightsManager().addEventToTatami(event, tatami);
            return new CommonResponse(added);
        }
        si.nevensrok.jtekma.common.tatami.Event event = this.getManagersList().getEventManager().getById(eventId);
        if (event != null) {
            Tatami tatami = this.getManagersList().getTatamiManager().getTatamiForEvent(event);
            si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for tataim");
            }
            event.setText(eventData.getText());
            event.setAutoRemove(eventData.getAutoRemove());
            this.getManagersList().getEventManager().updateEvent(event);
            return new CommonResponse(true);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/remove-event-from-tatami/{tatamiId}/{eventId}"})
    @ResponseBody
    public CommonResponse removeEventFromTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="eventId") Long eventId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.tatami.Event event = this.getManagersList().getEventManager().getById(eventId);
        if (event != null) {
            boolean removed = this.getManagersList().getTatamiFightsManager().removeEventFromTatami(event, tatami);
            return new CommonResponse(removed);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/moveup-event-tatami/{tatamiId}/{eventId}"})
    @ResponseBody
    public CommonResponse moveUpEventOnTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="eventId") Long eventId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.tatami.Event event = this.getManagersList().getEventManager().getById(eventId);
        if (event != null) {
            boolean moved = this.getManagersList().getTatamiFightsManager().moveEventOnTatamiUp(event, tatami);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/movedown-event-tatami/{tatamiId}/{eventId}"})
    @ResponseBody
    public CommonResponse moveDownEventOnTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="eventId") Long eventId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.tatami.Event event = this.getManagersList().getEventManager().getById(eventId);
        if (event != null) {
            boolean moved = this.getManagersList().getTatamiFightsManager().moveEventOnTatamiDown(event, tatami);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/move-event-tatami/{tatamiId}/{eventId}/{moveToSpot}"})
    @ResponseBody
    public CommonResponse moveEventOnTatamiToSpot(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="eventId") Long eventId, @PathVariable(value="moveToSpot") Integer moveToSpot) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.tatami.Event event = this.getManagersList().getEventManager().getById(eventId);
        if (event != null) {
            boolean moved = this.getManagersList().getTatamiFightsManager().moveEventOnTatamiToSpot(event, tatami, moveToSpot);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }

    @RequestMapping(value={"/match-deatils/{matchId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ReportChartData<Float> getMatchDetails(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="matchId") Long matchId) {
        ReportChartData<Float> reportChartData;
        block13: {
            si.nevensrok.jtekma.common.matches.Match match;
            Locale locale;
            block14: {
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setDateHeader("Expires", 0L);
                locale = RequestContextUtils.getLocale((HttpServletRequest)request);
                reportChartData = new ReportChartData<Float>();
                match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
                if (match == null) break block13;
                Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
                match.setCategory(category);
                si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
                if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                    throw new ForbiddenException("Invalid competition for category");
                }
                reportChartData.setChartData(new ArrayList());
                reportChartData.setCategories(new LinkedList<String>());
                reportChartData.setyAxisLabel(this.getLanguageText(locale, "competition.chart.points"));
                if (match.getType() != Match.Type.FIGHT && match.getType() != Match.Type.NEWAZA) break block14;
                reportChartData.setChartType("line");
                reportChartData.setxAxisLabel(this.getLanguageText(locale, "competition.chart.time"));
                reportChartData.setTooltipText(this.getLanguageText(locale, "competition.chart.tooltipForTime"));
                List reportDatas = this.getManagersList().getMatchManager().getPointsReportForFightMatch(match);
                for (int i = 0; i < 2; ++i) {
                    Object competitor;
                    ReportData reportData = (ReportData)reportDatas.get(i);
                    ChartData chartData = new ChartData();
                    reportChartData.getChartData().add(chartData);
                    chartData.setName("");
                    if (i == 0) {
                        competitor = match.getCompetitor1();
                        if (competitor != null) {
                            chartData.setName(CompetitorNameUtil.getCompetitorFullName((Competitor)competitor));
                        }
                    } else if (i == 1 && (competitor = match.getCompetitor2()) != null) {
                        chartData.setName(CompetitorNameUtil.getCompetitorFullName((Competitor)competitor));
                    }
                    chartData.setData(new LinkedList());
                    competitor = reportData.getData().iterator();
                    while (competitor.hasNext()) {
                        ReportData.Data data = (ReportData.Data)competitor.next();
                        chartData.getData().add(Float.valueOf(((Integer)data.getValue()).floatValue()));
                        if (i != 0) continue;
                        reportChartData.getCategories().add(((Integer)data.getIndex()).toString());
                    }
                }
                break block13;
            }
            if (match.getType() != Match.Type.DUO) break block13;
            reportChartData.setChartType("column");
            reportChartData.setxAxisLabel(this.getLanguageText(locale, "competition.chart.round"));
            reportChartData.setTooltipText(this.getLanguageText(locale, "competition.chart.tooltipForRound"));
            List reportDatas = this.getManagersList().getMatchManager().getPointsReportForDuoMatch(match);
            for (int i = 0; i < 2; ++i) {
                Competitor competitor;
                ReportData reportData = (ReportData)reportDatas.get(i);
                ChartData chartData = new ChartData();
                reportChartData.getChartData().add(chartData);
                chartData.setName("");
                if (i == 0) {
                    competitor = match.getCompetitor1();
                    if (competitor != null) {
                        chartData.setName(CompetitorNameUtil.getCompetitorFullName(competitor));
                    }
                } else if (i == 1 && (competitor = match.getCompetitor2()) != null) {
                    chartData.setName(CompetitorNameUtil.getCompetitorFullName(competitor));
                }
                chartData.setData(new LinkedList());
                for (ReportData.Data data : reportData.getData()) {
                    chartData.getData().add(data.getValue());
                    if (i != 0) continue;
                    reportChartData.getCategories().add(((Integer)data.getIndex()).toString());
                }
            }
        }
        return reportChartData;
    }

    @RequestMapping(value={"/tatami-history"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TatamiHistoryEvent> getTatamiHistory(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="tatamiId") Long tatamiId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        si.nevensrok.jtekma.common.competition.Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        LinkedList<TatamiHistoryEvent> tatamiHistoryEvents = new LinkedList<TatamiHistoryEvent>();
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setItemLimit(Integer.valueOf(20));
        dataFilter.setFetchCount(false);
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("eventDate", Sort.Field.Direction.DESC));
        PageDataResult dataResult = this.getManagersList().getTatamiHistoryManager().findTatamiHistory(tatami, (DataFilter)dataFilter);
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getLanguageText(locale, "dateformat.full"));
        for (TatamiHistory tatamiHistory : dataResult.getData()) {
            si.nevensrok.jtekma.common.matches.Match match = tatamiHistory.getMatch();
            if (match != null) {
                match = this.getManagersList().getMatchManager().getByIdWithCompetitors(match.getMatchId());
                Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
                match.setCategory(category);
            }
            TatamiHistoryEvent tatamiHistoryEvent = new TatamiHistoryEvent();
            tatamiHistoryEvent.setEventDate(tatamiHistory.getEventDate());
            tatamiHistoryEvent.setEventDateText(dateFormat.format(tatamiHistory.getEventDate()));
            tatamiHistoryEvent.setEventType(tatamiHistory.getEventType());
            if (match != null) {
                tatamiHistoryEvent.setMatch(new Match(match));
                TreeCategory treeCategory = null;
                if (match.getCategory() instanceof TreeCategory) {
                    treeCategory = (TreeCategory)match.getCategory();
                }
                if (treeCategory != null) {
                    tatamiHistoryEvent.getMatch().setName(this.getTools().getMatchTool().getMatchName(locale, treeCategory, match));
                    tatamiHistoryEvent.getMatch().setShortName(this.getTools().getMatchTool().getMatchShortName(treeCategory, match));
                }
                if (tatamiHistory.getEventType() == TatamiHistory.EventType.PUSHMATCH) {
                    Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
                    tatamiHistoryEvent.getMatch().setPoints1(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points)));
                    tatamiHistoryEvent.getMatch().setPoints2(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points)));
                }
            }
            tatamiHistoryEvents.add(tatamiHistoryEvent);
        }
        return tatamiHistoryEvents;
    }
}

