/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.formatter;

import java.text.ParseException;
import java.util.Locale;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import si.nevensrok.common.web.formatter.AbstractFormatterFactory;
import si.nevensrok.common.web.formatter.TimeFormatter;

public class TimeFormatterFactory
extends AbstractFormatterFactory<TimeFormatter> {
    public TimeFormatterFactory() {
        super(new Class[]{Long.class, Integer.class});
    }

    public Printer<?> getPrinter(final TimeFormatter annotation, Class<?> fieldType) {
        if (Long.class.isAssignableFrom(fieldType)) {
            return new Printer<Long>(){

                public String print(Long time, Locale locale) {
                    long fac = 1L;
                    if (annotation.millisecond()) {
                        fac = 1000L;
                    }
                    long remainingTime = time;
                    StringBuilder text = new StringBuilder();
                    if (annotation.hour()) {
                        long hours = remainingTime / (3600L * fac);
                        if (hours < 10L) {
                            text.append("0");
                        }
                        text.append(hours);
                        remainingTime -= hours * (3600L * fac);
                    }
                    text.append(":");
                    long minutes = remainingTime / (60L * fac);
                    if (minutes < 10L) {
                        text.append("0");
                    }
                    text.append(minutes);
                    text.append(":");
                    long seconds = (remainingTime -= minutes * (60L * fac)) / fac;
                    if (seconds < 10L) {
                        text.append("0");
                    }
                    text.append(seconds);
                    remainingTime -= seconds * fac;
                    if (annotation.millisecond()) {
                        text.append(".");
                        if (remainingTime < 10L) {
                            text.append("0");
                        }
                        if (remainingTime < 100L) {
                            text.append("0");
                        }
                        text.append(remainingTime);
                    }
                    return text.toString();
                }
            };
        }
        if (Integer.class.isAssignableFrom(fieldType)) {
            return new Printer<Integer>(){

                public String print(Integer time, Locale locale) {
                    long fac = 1L;
                    if (annotation.millisecond()) {
                        fac = 1000L;
                    }
                    long remainingTime = time.longValue();
                    StringBuilder text = new StringBuilder();
                    if (annotation.hour()) {
                        long hours = remainingTime / (3600L * fac);
                        if (hours < 10L) {
                            text.append("0");
                        }
                        text.append(hours);
                        remainingTime -= hours * (3600L * fac);
                    }
                    text.append(":");
                    long minutes = remainingTime / (60L * fac);
                    if (minutes < 10L) {
                        text.append("0");
                    }
                    text.append(minutes);
                    text.append(":");
                    long seconds = (remainingTime -= minutes * (60L * fac)) / fac;
                    if (seconds < 10L) {
                        text.append("0");
                    }
                    text.append(seconds);
                    remainingTime -= seconds * fac;
                    if (annotation.millisecond()) {
                        text.append(".");
                        if (remainingTime < 10L) {
                            text.append("0");
                        }
                        if (remainingTime < 100L) {
                            text.append("0");
                        }
                        text.append(remainingTime);
                    }
                    return text.toString();
                }
            };
        }
        throw new RuntimeException("Printer not found for type " + fieldType.getName());
    }

    public Parser<?> getParser(final TimeFormatter annotation, Class<?> fieldType) {
        if (Long.class.isAssignableFrom(fieldType)) {
            return new Parser<Long>(){

                public Long parse(String text, Locale locale) throws ParseException {
                    long fac = 1L;
                    if (annotation.millisecond()) {
                        fac = 1000L;
                    }
                    String[] parts = text.trim().split("[:]");
                    long time = 0L;
                    if (parts.length > 2) {
                        time += 3600L * fac * Long.parseLong(parts[0].trim());
                        time += 60L * fac * Long.parseLong(parts[1].trim());
                        if (annotation.millisecond()) {
                            String[] parts2 = parts[2].trim().split("[.]");
                            time += fac * Long.parseLong(parts2[0].trim());
                            if (parts2.length > 1) {
                                time += Long.parseLong(parts2[1].trim());
                            }
                        } else {
                            time += fac * Long.parseLong(parts[2].trim());
                        }
                    } else if (parts.length > 1) {
                        time += 60L * fac * Long.parseLong(parts[0].trim());
                        if (annotation.millisecond()) {
                            String[] parts2 = parts[1].trim().split("[.]");
                            time += fac * Long.parseLong(parts2[0].trim());
                            if (parts2.length > 1) {
                                time += Long.parseLong(parts2[1].trim());
                            }
                        } else {
                            time += fac * Long.parseLong(parts[2].trim());
                        }
                    } else if (parts.length == 1) {
                        if (annotation.millisecond()) {
                            String[] parts2 = parts[0].trim().split("[.]");
                            time += fac * Long.parseLong(parts2[0].trim());
                            if (parts2.length > 1) {
                                time += Long.parseLong(parts2[1].trim());
                            }
                        } else {
                            time += fac * Long.parseLong(parts[2].trim());
                        }
                    }
                    return time;
                }
            };
        }
        if (Integer.class.isAssignableFrom(fieldType)) {
            return new Parser<Integer>(){

                public Integer parse(String text, Locale locale) throws ParseException {
                    long fac = 1L;
                    if (annotation.millisecond()) {
                        fac = 1000L;
                    }
                    String[] parts = text.trim().split("[:]");
                    long time = 0L;
                    if (parts.length > 2) {
                        time += 3600L * fac * Long.parseLong(parts[0].trim());
                        time += 60L * fac * Long.parseLong(parts[1].trim());
                        if (annotation.millisecond()) {
                            String[] parts2 = parts[2].trim().split("[.]");
                            time += fac * Long.parseLong(parts2[0].trim());
                            if (parts2.length > 1) {
                                time += Long.parseLong(parts2[1].trim());
                            }
                        } else {
                            time += fac * Long.parseLong(parts[2].trim());
                        }
                    } else if (parts.length > 1) {
                        time += 60L * fac * Long.parseLong(parts[0].trim());
                        if (annotation.millisecond()) {
                            String[] parts2 = parts[1].trim().split("[.]");
                            time += fac * Long.parseLong(parts2[0].trim());
                            if (parts2.length > 1) {
                                time += Long.parseLong(parts2[1].trim());
                            }
                        } else {
                            time += fac * Long.parseLong(parts[2].trim());
                        }
                    } else if (parts.length == 1) {
                        if (annotation.millisecond()) {
                            String[] parts2 = parts[0].trim().split("[.]");
                            time += fac * Long.parseLong(parts2[0].trim());
                            if (parts2.length > 1) {
                                time += Long.parseLong(parts2[1].trim());
                            }
                        } else {
                            time += fac * Long.parseLong(parts[2].trim());
                        }
                    }
                    return new Long(time).intValue();
                }
            };
        }
        throw new RuntimeException("Parser not found for type " + fieldType.getName());
    }
}

