/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryMatchCount;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competition.AutomationSettings;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionAutomationManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.TatamiFightsManager;
import si.nevensrok.jtekma.server.management.TatamiManager;
import si.nevensrok.jtekma.server.management.TreeAdvancmentManager;

public class CompetitionAutomationManagerImpl
implements CompetitionAutomationManager {
    private static final Logger log = LoggerFactory.getLogger(CompetitionAutomationManagerImpl.class);
    private CompetitionManager competitionManager;
    private CategoryManager categoryManager;
    private TatamiManager tatamiManager;
    private TatamiFightsManager tatamiFightsManager;
    private MatchManager matchManager;
    private TreeAdvancmentManager treeAdvancmentManager;

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public void setTatamiFightsManager(TatamiFightsManager tatamiFightsManager) {
        this.tatamiFightsManager = tatamiFightsManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setTreeAdvancmentManager(TreeAdvancmentManager treeAdvancmentManager) {
        this.treeAdvancmentManager = treeAdvancmentManager;
    }

    @Transactional(value="jtekmaTransactionManager")
    public void putMatchesOnTatamis(Competition competition) {
        AutomationSettings automationSettings = this.competitionManager.getAutomationSettings(competition);
        List tatamis = this.tatamiManager.find(competition, (DataFilter)new SimpleDataFilter()).getData();
        ArrayList categories = new ArrayList(this.categoryManager.getCategoriesForAutomation(competition));
        Map matchCount = this.categoryManager.getCategoryMatchCount(new HashSet(categories));
        Map tatamisForCategory = this.tatamiManager.getTatamisForCategories(new HashSet(categories));
        HashMap categoriesForTatami = new HashMap();
        for (Tatami tatami : tatamis) {
            categoriesForTatami.put(tatami, new LinkedList());
        }
        for (Category category : categories) {
            CategoryMatchCount categoryMatchCount = (CategoryMatchCount)matchCount.get(category);
            if (categoryMatchCount.getNeededMatches() <= 0) continue;
            for (Tatami tatami : (Set)tatamisForCategory.get(category)) {
                ((List)categoriesForTatami.get(tatami)).add(category);
            }
        }
        block3: for (Tatami tatami : tatamis) {
            while (true) {
                int matchesOnTatami = 0;
                ArrayList fightOrders = new ArrayList(this.tatamiManager.getFightOrderForTatami(tatami));
                HashSet<Competitor> lastCompetitors = new HashSet<Competitor>();
                for (int i = fightOrders.size() - 1; i >= 0; --i) {
                    Match match = ((FightOrder)fightOrders.get(i)).getMatch();
                    if (match == null) continue;
                    match = this.matchManager.getByIdWithCompetitors(match.getMatchId());
                    if (++matchesOnTatami > automationSettings.getMinimumMatchDifferenceForCompetitor()) continue;
                    if (match.getCompetitor1() != null) {
                        lastCompetitors.add(match.getCompetitor1());
                    }
                    if (match.getCompetitor2() == null) continue;
                    lastCompetitors.add(match.getCompetitor2());
                }
                if (matchesOnTatami >= automationSettings.getCalculateForMatchesInAdvance()) continue block3;
                log.trace("Adding match to tatami [{}]", (Object)tatami);
                Match nextMatch = this.getNextMetchFromCategories((List)categoriesForTatami.get(tatami), lastCompetitors);
                if (nextMatch == null) break;
                log.trace("Adding match [{}] to tatami", (Object)nextMatch);
                this.tatamiFightsManager.addMatchToTatami(nextMatch, tatami);
            }
            log.trace("No new matches found");
        }
    }

    private Match getNextMetchFromCategories(List<Category> categories, Set<Competitor> lastCompetitors) {
        Match bestCandidate = null;
        for (Category category : categories) {
            TreeCategory treeCategory;
            TreeAdvancment treeAdvancment;
            List matches = this.matchManager.getMatchesForCategory(category);
            HashMap<Integer, Match> matchByFightNumber = new HashMap<Integer, Match>();
            for (Match match : matches) {
                matchByFightNumber.put(match.getFightNumber(), match);
            }
            if (category instanceof TreeCategory && (treeAdvancment = this.treeAdvancmentManager.getForCategory(treeCategory = (TreeCategory)category)) != null && treeAdvancment.getTreeAdvancmentId() == 1L) {
                if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE3) {
                    matches.clear();
                    matches.add(matchByFightNumber.get(5));
                    matches.add(matchByFightNumber.get(4));
                    matches.add(matchByFightNumber.get(8));
                } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE4) {
                    matches.clear();
                    matches.add(matchByFightNumber.get(7));
                    matches.add(matchByFightNumber.get(8));
                    matches.add(matchByFightNumber.get(2));
                    matches.add(matchByFightNumber.get(4));
                    matches.add(matchByFightNumber.get(9));
                    matches.add(matchByFightNumber.get(5));
                }
            }
            for (Match match : matches) {
                if (match.getStatus() != Match.Status.WAITING || match.getNotNeeded().booleanValue() || match.getCompetitor1() == null || match.getCompetitor2() == null) continue;
                if (!lastCompetitors.contains(match.getCompetitor1()) && !lastCompetitors.contains(match.getCompetitor2())) {
                    return match;
                }
                if (bestCandidate != null) continue;
                bestCandidate = match;
            }
        }
        return bestCandidate;
    }
}

