/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import si.nevensrok.common.settings.Section;
import si.nevensrok.common.settings.SectionTransformer;
import si.nevensrok.common.settings.schema.SectionType;
import si.nevensrok.common.settings.util.SystemInfo;

public class Settings
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(Settings.class);
    private static final String settingsFileName = "settings.dat";
    private static final String settingsFileBackupName = "settings.dat.old";
    private String applicationName = null;
    private String path = null;
    private DatatypeFactory datatypeFactory;
    private Jaxb2Marshaller jax2Marshaller;
    private File settingsDirectory;
    private Section rootSection;
    private File filesDirectory;
    private Object settingsFileMonitor = new Object();
    private Object saveSettingsFileThreadMonitor = new Object();
    private Thread saveSettingsFileThread = null;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Settings() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            log.error("Error initializing datatype factory", (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.applicationName == null && this.path == null) {
            throw new IllegalArgumentException("Property 'applicationName' or 'path' is requied");
        }
        if (this.path != null) {
            if (log.isTraceEnabled()) {
                log.trace("Using path: {}", (Object)this.path);
            }
            this.settingsDirectory = new File(this.path);
        } else {
            File homeDir = SystemInfo.getUserHomeDir();
            if (homeDir == null) {
                throw new RuntimeException("Home directory of user not found");
            }
            if (log.isTraceEnabled()) {
                log.trace("Using users home direcotry: {}", (Object)homeDir.getAbsoluteFile());
            }
            this.settingsDirectory = new File(homeDir, "." + this.applicationName);
            if (log.isTraceEnabled()) {
                log.trace("Settings directory: {}", (Object)this.settingsDirectory.getAbsoluteFile());
            }
        }
        if (!this.settingsDirectory.exists()) {
            if (log.isTraceEnabled()) {
                log.trace("Creating directory: {}", (Object)this.settingsDirectory.getAbsolutePath());
            }
            if (!this.settingsDirectory.mkdirs()) {
                throw new RuntimeException("Can't create directory '" + this.settingsDirectory.getAbsolutePath() + "'");
            }
        }
        if (!this.settingsDirectory.isDirectory()) {
            throw new RuntimeException("Path '" + this.settingsDirectory.getAbsolutePath() + "' is not directory");
        }
        if (!this.settingsDirectory.canWrite()) {
            throw new RuntimeException("Path '" + this.settingsDirectory.getAbsolutePath() + "' is not writeable");
        }
        this.jax2Marshaller = new Jaxb2Marshaller();
        this.jax2Marshaller.setPackagesToScan(new String[]{"si.nevensrok.common.settings.schema"});
        this.jax2Marshaller.afterPropertiesSet();
        this.load();
        this.filesDirectory = new File(this.settingsDirectory, "files");
        if (!this.filesDirectory.exists()) {
            if (log.isTraceEnabled()) {
                log.trace("Creating directory: {}", (Object)this.filesDirectory.getAbsolutePath());
            }
            if (!this.filesDirectory.mkdirs()) {
                throw new RuntimeException("Can't create directory '" + this.filesDirectory.getAbsolutePath() + "'");
            }
        }
        if (!this.filesDirectory.isDirectory()) {
            throw new RuntimeException("Path '" + this.filesDirectory.getAbsolutePath() + "' is not directory");
        }
        if (!this.filesDirectory.canWrite()) {
            throw new RuntimeException("Path '" + this.filesDirectory.getAbsolutePath() + "' is not writeable");
        }
    }

    public void destroy() throws Exception {
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        Object object = this.settingsFileMonitor;
        synchronized (object) {
            block8: {
                if (log.isTraceEnabled()) {
                    log.trace("Saving settings file");
                }
                File backupSettingsFile = new File(this.settingsDirectory, settingsFileBackupName);
                backupSettingsFile.delete();
                File settingsFile = new File(this.settingsDirectory, settingsFileName);
                settingsFile.renameTo(backupSettingsFile);
                si.nevensrok.common.settings.schema.Settings settings = new si.nevensrok.common.settings.schema.Settings();
                settings.setSaved(this.datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar()));
                SectionType rootSectionType = SectionTransformer.toSectionType(this.rootSection);
                settings.setSection(rootSectionType);
                settingsFile = new File(this.settingsDirectory, settingsFileName);
                OutputStream outputStream = null;
                try {
                    outputStream = new GZIPOutputStream(new FileOutputStream(settingsFile));
                    this.jax2Marshaller.marshal((Object)settings, (Result)new StreamResult(outputStream));
                    outputStream.close();
                }
                catch (Exception e) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!log.isDebugEnabled()) break block8;
                    log.debug("Error saving settings file", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Object object = this.settingsFileMonitor;
        synchronized (object) {
            if (log.isTraceEnabled()) {
                log.trace("Loading settings file");
            }
            File settingsFile = new File(this.settingsDirectory, settingsFileName);
            File backupSettingsFile = new File(this.settingsDirectory, settingsFileBackupName);
            InputStream inputStream = null;
            try {
                inputStream = new GZIPInputStream(new FileInputStream(settingsFile));
                si.nevensrok.common.settings.schema.Settings settings = (si.nevensrok.common.settings.schema.Settings)this.jax2Marshaller.unmarshal((Source)new StreamSource(inputStream));
                inputStream.close();
                this.rootSection = SectionTransformer.toSection(this, settings.getSection());
                return;
            }
            catch (Exception e) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug("Error loading settings file", (Throwable)e);
                }
                if (log.isTraceEnabled()) {
                    log.trace("Loading settings from backup file");
                }
                backupSettingsFile.renameTo(settingsFile);
                try {
                    inputStream = new GZIPInputStream(new FileInputStream(settingsFile));
                    si.nevensrok.common.settings.schema.Settings settings = (si.nevensrok.common.settings.schema.Settings)this.jax2Marshaller.unmarshal((Source)new StreamSource(inputStream));
                    inputStream.close();
                    this.rootSection = SectionTransformer.toSection(this, settings.getSection());
                    return;
                }
                catch (Exception e2) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Error loading settings file from backup", (Throwable)e2);
                    }
                    this.rootSection = new Section("root", this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markChange() {
        Object object = this.saveSettingsFileThreadMonitor;
        synchronized (object) {
            if (this.saveSettingsFileThread != null) {
                return;
            }
            this.saveSettingsFileThread = new Thread("Save settings file thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Settings.this.save();
                    Object object = Settings.this.saveSettingsFileThreadMonitor;
                    synchronized (object) {
                        Settings.this.saveSettingsFileThread = null;
                    }
                }
            };
            this.saveSettingsFileThread.start();
        }
    }

    public Section getRootSection() {
        return this.rootSection;
    }

    public File getFilesDirectory() {
        return this.filesDirectory;
    }
}

