/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.jms;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import si.nevensrok.common.jms.MessageProcessorChecker;

public class MemoryMessageProcessorChecker
implements MessageProcessorChecker {
    private int maxMessages;
    private Set<String> messageIdSet = new HashSet<String>();
    private LinkedList<String> messageIdList = new LinkedList();

    public MemoryMessageProcessorChecker() {
        this(10000);
    }

    public MemoryMessageProcessorChecker(int maxMessages) {
        this.maxMessages = maxMessages;
    }

    @Override
    public synchronized boolean wasMessageAlreadyProcessed(Message message) {
        try {
            String messageId = message.getJMSMessageID();
            if (this.messageIdSet.contains(messageId)) {
                return true;
            }
            this.messageIdSet.add(messageId);
            this.messageIdList.addFirst(messageId);
            while (this.messageIdList.size() > this.maxMessages) {
                String removed = this.messageIdList.removeLast();
                this.messageIdSet.remove(removed);
            }
            return false;
        }
        catch (JMSException e) {
            throw new RuntimeException("Error checking if message is i", e);
        }
    }
}

