/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.encryption;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import si.nevensrok.common.utils.HashUtil;

public class AesKeyGenerator {
    private static final Random RANDOM = new Random();

    public static int getMaximumKeySize() {
        try {
            return Cipher.getMaxAllowedKeyLength("AES") / 8;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while checking maximum key size", e);
        }
    }

    public static SecretKey generateKey(byte[] data) {
        return new SecretKeySpec(data, "AES");
    }

    public static SecretKey generateKey(String password) {
        return AesKeyGenerator.generateKey(HashUtil.generateHash((byte[])password.getBytes(Charset.forName("UTF8")), (HashUtil.HashType)HashUtil.HashType.SHA256));
    }

    public static SecretKey generateKey(String password, int length) {
        int i;
        ArrayList<Byte> bytes = new ArrayList<Byte>(length);
        byte[] previousHash = null;
        while (bytes.size() < length) {
            byte[] hash = previousHash == null ? HashUtil.generateHash((byte[])password.getBytes(Charset.forName("UTF8")), (HashUtil.HashType)HashUtil.HashType.SHA256) : HashUtil.generateHash(Arrays.asList(previousHash, password.getBytes(Charset.forName("UTF8"))), (HashUtil.HashType)HashUtil.HashType.SHA256);
            previousHash = hash;
            for (i = 0; i < hash.length && bytes.size() < length; ++i) {
                bytes.add(hash[i]);
            }
        }
        byte[] key = new byte[length];
        for (i = 0; i < key.length; ++i) {
            key[i] = (Byte)bytes.get(i);
        }
        return AesKeyGenerator.generateKey(key);
    }

    public static SecretKey generateRandomKey(int length) {
        byte[] keyBytes = new byte[length];
        RANDOM.nextBytes(keyBytes);
        return new SecretKeySpec(keyBytes, "AES");
    }
}

