/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.fightinfo.gui;

import java.awt.EventQueue;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JPanel;
import org.springframework.context.ApplicationContext;
import si.nevensrok.jtekma.common.fightinfo.CurrentMatchInfo;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.fightinfo.common.FightWindowData;
import si.nevensrok.jtekma.fightinfo.gui.FightLineInfo;

public class FightLineTable
extends JPanel {
    private static final long serialVersionUID = -7638442882899532259L;
    private ApplicationContext applicationContext;
    private Locale locale;
    private Map<Long, FightLineInfo> lines = new LinkedHashMap<Long, FightLineInfo>();

    public FightLineTable(ApplicationContext applicationContext, Locale locale) {
        this.applicationContext = applicationContext;
        this.locale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFightLineTable(List<CurrentMatchInfo> currentMatchInfoList) {
        boolean changed = false;
        Map<Long, FightLineInfo> map = this.lines;
        synchronized (map) {
            HashSet<Long> unused = new HashSet<Long>(this.lines.keySet());
            for (CurrentMatchInfo currentMatchInfo : currentMatchInfoList) {
                Tatami tatami = currentMatchInfo.getTatami();
                FightLineInfo fightLineInfo = this.lines.get(tatami.getTatamiId());
                if (fightLineInfo == null) {
                    fightLineInfo = new FightLineInfo(this.applicationContext, this.locale, tatami);
                    this.lines.put(tatami.getTatamiId(), fightLineInfo);
                    changed = true;
                    continue;
                }
                unused.remove(tatami.getTatamiId());
                fightLineInfo.updateData(tatami);
            }
            if (!unused.isEmpty()) {
                changed = true;
                for (Long tatamiId : unused) {
                    this.lines.remove(tatamiId);
                }
            }
        }
        if (changed) {
            this.reloadLines();
        }
    }

    private void reloadLines() {
        final LinkedHashMap<Long, FightLineInfo> currentLines = new LinkedHashMap<Long, FightLineInfo>(this.lines);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FightLineTable.this.setLayout(new GridLayout(currentLines.size(), 1));
                ArrayList<Tatami> tatamis = new ArrayList<Tatami>(currentLines.size());
                for (FightLineInfo fightLineInfo : currentLines.values()) {
                    FightLineTable.this.remove(fightLineInfo);
                    tatamis.add(fightLineInfo.getTatami());
                }
                Collections.sort(tatamis, new Comparator<Tatami>(){

                    @Override
                    public int compare(Tatami o1, Tatami o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                for (Tatami tatami : tatamis) {
                    FightLineInfo fightLineInfo = (FightLineInfo)currentLines.get(tatami.getTatamiId());
                    FightLineTable.this.add(fightLineInfo);
                }
                FightLineTable.this.revalidate();
                FightLineTable.this.repaint();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FightWindowData> getFightWindowDatas() {
        Map<Long, FightLineInfo> map = this.lines;
        synchronized (map) {
            LinkedList<FightWindowData> fightWindowDataList = new LinkedList<FightWindowData>();
            for (FightLineInfo fightLineInfo : this.lines.values()) {
                fightWindowDataList.add(fightLineInfo.getFightWindowData());
            }
            return fightWindowDataList;
        }
    }
}

