/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.restclient;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import si.nevensrok.common.restclient.RestApiException;
import si.nevensrok.common.restclient.RestApiResponseException;
import si.nevensrok.common.restclient.RestRequest;
import si.nevensrok.common.restclient.RestResponse;
import si.nevensrok.common.utils.CloseUtil;
import si.nevensrok.common.utils.StringUtil;

public class RestClient {
    private int connectTimeout = 10000;
    private int readTimeout = 60000;

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void execute(String method, String url) {
        this.execute(method, url, null, null, null, null);
    }

    public void execute(String method, String url, String contentType, byte[] body) {
        this.execute(method, url, contentType, body, null, null);
    }

    public void execute(String method, String url, String contentType, byte[] body, Map<String, String> queryParameters) {
        this.execute(method, url, contentType, body, queryParameters, null);
    }

    public void execute(String method, String url, String contentType, byte[] body, Map<String, String> queryParameters, Map<String, String> headers) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(method);
        restRequest.setUrl(url);
        if (queryParameters != null) {
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                restRequest.setQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                restRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
        restRequest.setContentType(contentType);
        restRequest.setBody(body);
        RestResponse restResponse = this.execute(restRequest);
        if (!restResponse.isSuccessful()) {
            throw new RestApiResponseException("Error response code received", restResponse.getResponseCode());
        }
    }

    public byte[] executeAndRead(String method, String url) {
        return this.executeAndRead(method, url, null, null, null, null);
    }

    public byte[] executeAndRead(String method, String url, String contentType, byte[] body) {
        return this.executeAndRead(method, url, contentType, body, null, null);
    }

    public byte[] executeAndRead(String method, String url, String contentType, byte[] body, Map<String, String> queryParameters) {
        return this.executeAndRead(method, url, contentType, body, queryParameters, null);
    }

    public byte[] executeAndRead(String method, String url, String contentType, byte[] body, Map<String, String> queryParameters, Map<String, String> headers) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(method);
        restRequest.setUrl(url);
        if (queryParameters != null) {
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                restRequest.setQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                restRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
        restRequest.setContentType(contentType);
        restRequest.setBody(body);
        RestResponse restResponse = this.execute(restRequest);
        if (!restResponse.isSuccessful()) {
            throw new RestApiResponseException("Error response code received", restResponse.getResponseCode());
        }
        return restResponse.getBody();
    }

    public String executeAndReadAsString(String method, String url) {
        return this.executeAndReadAsString(method, url, null, null, null, null);
    }

    public String executeAndReadAsString(String method, String url, String contentType, byte[] body) {
        return this.executeAndReadAsString(method, url, contentType, body, null, null);
    }

    public String executeAndReadAsString(String method, String url, String contentType, byte[] body, Map<String, String> queryParameters) {
        return this.executeAndReadAsString(method, url, contentType, body, queryParameters, null);
    }

    public String executeAndReadAsString(String method, String url, String contentType, byte[] body, Map<String, String> queryParameters, Map<String, String> headers) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(method);
        restRequest.setUrl(url);
        if (queryParameters != null) {
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                restRequest.setQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                restRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
        restRequest.setContentType(contentType);
        restRequest.setBody(body);
        RestResponse restResponse = this.execute(restRequest);
        if (!restResponse.isSuccessful()) {
            throw new RestApiResponseException("Error response code received", restResponse.getResponseCode());
        }
        return restResponse.getBodyAsString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RestResponse execute(RestRequest restRequest) {
        RestResponse restResponse2;
        if (StringUtil.isEmpty((String)restRequest.getUrl())) {
            throw new RestApiException("Rest request url is empty");
        }
        if (StringUtil.isEmpty((String)restRequest.getMethod())) {
            throw new RestApiException("Rest request method is empty");
        }
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            StringBuilder fullUrl = new StringBuilder();
            fullUrl.append(restRequest.getUrl());
            for (Map.Entry<String, List<String>> entry : restRequest.getQueryParameters().entrySet()) {
                for (String string : entry.getValue()) {
                    if (fullUrl.indexOf("?") < 0) {
                        fullUrl.append("?");
                    } else {
                        fullUrl.append("&");
                    }
                    fullUrl.append(URLEncoder.encode(entry.getKey(), "UTF8"));
                    if (string == null) continue;
                    fullUrl.append("=");
                    fullUrl.append(URLEncoder.encode(string, "UTF8"));
                }
            }
            URL url = new URL(fullUrl.toString());
            httpURLConnection = (HttpURLConnection)url.openConnection();
            int connectTimeout = this.getConnectTimeout();
            if (restRequest.getConnectTimeout() != null) {
                connectTimeout = restRequest.getConnectTimeout();
            }
            if (connectTimeout < 0) {
                connectTimeout = 0;
            }
            httpURLConnection.setConnectTimeout(connectTimeout);
            int readTimeout = this.getReadTimeout();
            if (restRequest.getReadTimeout() != null) {
                readTimeout = restRequest.getReadTimeout();
            }
            if (readTimeout < 0) {
                readTimeout = 0;
            }
            httpURLConnection.setReadTimeout(readTimeout);
            httpURLConnection.setRequestMethod(restRequest.getMethod());
            for (Map.Entry<String, List<String>> entry : restRequest.getHeaders().entrySet()) {
                if (entry.getValue() == null) continue;
                for (String value : entry.getValue()) {
                    if (value == null) continue;
                    httpURLConnection.addRequestProperty(entry.getKey(), value);
                }
            }
            if (restRequest.getBody() != null) {
                httpURLConnection.setDoOutput(true);
                outputStream = httpURLConnection.getOutputStream();
                outputStream.write(restRequest.getBody());
                outputStream.flush();
                outputStream.close();
            }
            httpURLConnection.connect();
            RestResponse restResponse = new RestResponse();
            restResponse.setResponseCode(httpURLConnection.getResponseCode());
            for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                for (String value : entry.getValue()) {
                    restResponse.addHeader(entry.getKey(), value);
                }
            }
            inputStream = httpURLConnection.getErrorStream();
            if (inputStream == null) {
                inputStream = httpURLConnection.getInputStream();
            }
            if (inputStream != null) {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n2 = inputStream.read();
                while (n >= 0) {
                    byteArrayOutputStream.write(n);
                    n = inputStream.read();
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                restResponse.setBody(byArray);
            }
            restResponse2 = restResponse;
        }
        catch (Throwable e) {
            try {
                throw new RestApiException("Error executing rest api method", e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{outputStream, inputStream});
                try {
                    httpURLConnection.disconnect();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{outputStream, inputStream});
        try {
            httpURLConnection.disconnect();
            return restResponse2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return restResponse2;
    }

    static {
        try {
            Field methodsField = HttpURLConnection.class.getDeclaredField("methods");
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(methodsField, methodsField.getModifiers() & 0xFFFFFFEF);
            methodsField.setAccessible(true);
            String[] oldMethods = (String[])methodsField.get(null);
            LinkedHashSet<String> methodsSet = new LinkedHashSet<String>(Arrays.asList(oldMethods));
            methodsSet.add("PATCH");
            String[] newMethods = methodsSet.toArray(new String[methodsSet.size()]);
            methodsField.set(null, newMethods);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

