/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.request;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import si.nevensrok.common.request.Callback;

public class FutureResult<S>
implements Future<S>,
Callback<S> {
    private boolean responseReceived = false;
    private boolean errorWhileExecution = false;
    private boolean canceled = false;
    private S result;
    private Throwable error;

    @Override
    public synchronized void success(S response) {
        if (!this.responseReceived) {
            this.responseReceived = true;
            this.result = response;
            this.notifyAll();
        }
    }

    @Override
    public synchronized void error(Throwable error) {
        if (!this.responseReceived) {
            this.responseReceived = true;
            this.errorWhileExecution = true;
            this.error = error;
            this.notifyAll();
        }
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.responseReceived) {
            return false;
        }
        if (mayInterruptIfRunning) {
            this.responseReceived = true;
            this.canceled = true;
            this.notifyAll();
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        return this.responseReceived;
    }

    @Override
    public synchronized S get() throws InterruptedException, ExecutionException {
        while (true) {
            if (this.responseReceived) {
                if (this.canceled) {
                    throw new CancellationException();
                }
                if (this.errorWhileExecution) {
                    throw new ExecutionException(this.error);
                }
                return this.result;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    @Override
    public synchronized S get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long waitUntil = System.currentTimeMillis() + unit.toMillis(timeout);
        while (true) {
            if (this.responseReceived) {
                if (this.canceled) {
                    throw new CancellationException();
                }
                if (this.errorWhileExecution) {
                    throw new ExecutionException(this.error);
                }
                return this.result;
            }
            long waitTime = waitUntil - System.currentTimeMillis();
            if (waitTime <= 0L) break;
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        throw new TimeoutException("Timeout expired");
    }
}

