/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public final class MachineInfoUtil {
    private MachineInfoUtil() {
    }

    public static List<NetworkInterface> getActiveNetworkInterfaces() {
        LinkedList<NetworkInterface> networkInterfaces = new LinkedList<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> networkInterfaceEnumerator = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaceEnumerator.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaceEnumerator.nextElement();
                if (!networkInterface.isUp()) continue;
                networkInterfaces.add(networkInterface);
                networkInterfaces.add(networkInterface);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return networkInterfaces;
    }

    public static String getMachineIp4Address() {
        try {
            for (NetworkInterface networkInterface : MachineInfoUtil.getActiveNetworkInterfaces()) {
                if (networkInterface.isLoopback() || networkInterface.isVirtual()) continue;
                Enumeration<InetAddress> addressEnumerator = networkInterface.getInetAddresses();
                while (addressEnumerator.hasMoreElements()) {
                    InetAddress address = addressEnumerator.nextElement();
                    if (!(address instanceof Inet4Address)) continue;
                    Inet4Address inet4Address = (Inet4Address)address;
                    return inet4Address.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static List<String> getMachineIp4Addresses() {
        LinkedList<String> list = new LinkedList<String>();
        try {
            for (NetworkInterface networkInterface : MachineInfoUtil.getActiveNetworkInterfaces()) {
                if (networkInterface.isLoopback() || networkInterface.isVirtual()) continue;
                Enumeration<InetAddress> addressEnumerator = networkInterface.getInetAddresses();
                while (addressEnumerator.hasMoreElements()) {
                    InetAddress address = addressEnumerator.nextElement();
                    if (!(address instanceof Inet4Address)) continue;
                    Inet4Address inet4Address = (Inet4Address)address;
                    list.add(inet4Address.getHostAddress());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static String getMachineIp6Address() {
        String fallbackAddress = null;
        try {
            Enumeration<NetworkInterface> networkInterfaceEnumerator = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaceEnumerator.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaceEnumerator.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual()) continue;
                Enumeration<InetAddress> addressEnumerator = networkInterface.getInetAddresses();
                while (addressEnumerator.hasMoreElements()) {
                    InetAddress address = addressEnumerator.nextElement();
                    if (!(address instanceof Inet6Address)) continue;
                    Inet6Address inet6Address = (Inet6Address)address;
                    String ipAddress = MachineInfoUtil.extractOnlyIpv6IpAddress(inet6Address.getHostAddress());
                    if (ipAddress.startsWith("fe80:")) {
                        if (fallbackAddress != null) continue;
                        fallbackAddress = ipAddress;
                        continue;
                    }
                    return ipAddress;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallbackAddress;
    }

    public static List<String> getMachineIp6Addresses() {
        LinkedList<String> list = new LinkedList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaceEnumerator = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaceEnumerator.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaceEnumerator.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual()) continue;
                Enumeration<InetAddress> addressEnumerator = networkInterface.getInetAddresses();
                while (addressEnumerator.hasMoreElements()) {
                    InetAddress address = addressEnumerator.nextElement();
                    if (!(address instanceof Inet6Address)) continue;
                    Inet6Address inet6Address = (Inet6Address)address;
                    list.add(MachineInfoUtil.extractOnlyIpv6IpAddress(inet6Address.getHostAddress()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static List<String> getMachineGlobalIp6Addresses() {
        LinkedList<String> list = new LinkedList<String>();
        for (String address : MachineInfoUtil.getMachineIp6Addresses()) {
            if (address.startsWith("fe80:")) continue;
            list.add(address);
        }
        return list;
    }

    public static List<String> getMachineLinkIp6Addresses() {
        LinkedList<String> list = new LinkedList<String>();
        for (String address : MachineInfoUtil.getMachineIp6Addresses()) {
            if (!address.startsWith("fe80:")) continue;
            list.add(address);
        }
        return list;
    }

    public static String extractOnlyIpv6IpAddress(String address) {
        if (address == null) {
            return null;
        }
        int n = address.indexOf(37);
        if (n <= 0) {
            return address;
        }
        return address.substring(0, n);
    }

    public static String getMachineHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getProcessName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }
}

