/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.usage;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.usage.MethodInfo;
import si.nevensrok.common.usage.UsageRecorder;

public class DatabaseUsageRecorder
implements UsageRecorder {
    private static final Logger log = LoggerFactory.getLogger(DatabaseUsageRecorder.class);
    private String driver;
    private String url;
    private String username;
    private String password;
    private String table = "methodusage";

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public void logUsageRecords(List<MethodInfo> methodInfos) {
        Connection connection = this.openConnection();
        try {
            connection.setSavepoint();
            for (MethodInfo methodInfo : methodInfos) {
                PreparedStatement preparedStatement = connection.prepareStatement("insert into " + this.table + " (UsageDate,MethodName,BeanName,UsageCount,MaxDuration,MinDuration,AverageDuration) values (?,?,?,?,?,?,?)");
                preparedStatement.setTimestamp(1, new Timestamp(Calendar.getInstance().getTimeInMillis()));
                preparedStatement.setString(2, methodInfo.getName());
                preparedStatement.setString(3, methodInfo.getBeanName());
                preparedStatement.setInt(4, methodInfo.getCount());
                preparedStatement.setLong(5, methodInfo.getMaxDuration());
                preparedStatement.setLong(6, methodInfo.getMinDuration());
                preparedStatement.setLong(7, methodInfo.getAverateDuration());
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            connection.commit();
            connection.close();
        }
        catch (Exception e) {
            log.error("Error saving request to database", (Throwable)e);
            try {
                connection.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Connection openConnection() {
        try {
            Class.forName(this.driver);
            Connection connection = DriverManager.getConnection(this.url, this.username, this.password);
            connection.setAutoCommit(false);
            return connection;
        }
        catch (Exception e) {
            log.error("Error oppening connection", (Throwable)e);
            return null;
        }
    }
}

