/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.TaskExecutor;
import si.nevensrok.common.jms.JmsProcessorInstance;
import si.nevensrok.common.jms.MessageHandler;
import si.nevensrok.common.jms.MessageProcessorChecker;
import si.nevensrok.common.jms.SourceType;

public class JmsMessageProcessor
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(JmsMessageProcessor.class);
    private ConnectionFactory connectionFactory;
    private String source;
    private SourceType sourceType = SourceType.QUEUE;
    private MessageHandler messageHandler;
    private int deliveryMode = 1;
    private int priority = -1;
    private int timeToLive = -1;
    private boolean transacted = false;
    private int acknowledgeMode = 1;
    private int consumers = 1;
    private MessageProcessorChecker messageProcessorChecker = null;
    private TaskExecutor taskExecutor = null;
    private Connection connection;
    private JmsProcessorInstance[] jmsProcessorInstances;

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public int getConsumers() {
        return this.consumers;
    }

    public void setConsumers(int consumers) {
        this.consumers = consumers;
    }

    public MessageProcessorChecker getMessageProcessorChecker() {
        return this.messageProcessorChecker;
    }

    public void setMessageProcessorChecker(MessageProcessorChecker messageProcessorChecker) {
        this.messageProcessorChecker = messageProcessorChecker;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void afterPropertiesSet() throws Exception {
        log.debug("Initializing message processor");
        if (this.getConnectionFactory() == null) {
            throw new IllegalArgumentException("Property 'connectionFactory' is required");
        }
        if (this.getSource() == null) {
            throw new IllegalArgumentException("Property 'source' is required");
        }
        if (this.getSourceType() == null) {
            throw new IllegalArgumentException("Property 'sourceType' is required");
        }
        if (this.getMessageHandler() == null) {
            throw new IllegalArgumentException("Property 'messageHandler' is required");
        }
        if (this.getConsumers() < 1) {
            throw new IllegalArgumentException("Property 'consumers' must be higher that 0");
        }
        this.connection = this.getConnectionFactory().createConnection();
        this.connection.start();
        this.jmsProcessorInstances = new JmsProcessorInstance[this.getConsumers()];
        for (int i = 0; i < this.getConsumers(); ++i) {
            this.jmsProcessorInstances[i] = new JmsProcessorInstance(this.connection, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive(), this.isTransacted(), this.getAcknowledgeMode(), this.getTaskExecutor(), this.getSource(), this.getSourceType(), this.getMessageHandler(), this.getMessageProcessorChecker());
        }
    }

    public void destroy() throws Exception {
        log.debug("Closing message processor");
        try {
            for (int i = 0; i < this.jmsProcessorInstances.length; ++i) {
                try {
                    this.jmsProcessorInstances[i].close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

