/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.semafor.fw;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;
import si.nevensrok.jtekma.common.tatami.TatamiFightData;
import si.nevensrok.jtekma.services.SemaphoreService;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.services.common.ServiceException;

public class SemaphoreServiceClient
implements SemaphoreService,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SemaphoreServiceClient.class);
    private HttpInvokerRequestExecutor httpInvokerRequestExecutor;
    private SemaphoreService semaphoreService = null;
    private List<DisposableBean> beansToClose = new LinkedList<DisposableBean>();

    public void setHttpInvokerRequestExecutor(HttpInvokerRequestExecutor httpInvokerRequestExecutor) {
        this.httpInvokerRequestExecutor = httpInvokerRequestExecutor;
    }

    public void destroy() throws Exception {
        for (DisposableBean disposableBean : this.beansToClose) {
            try {
                disposableBean.destroy();
            }
            catch (Throwable throwable) {}
        }
        this.beansToClose.clear();
        this.semaphoreService = null;
    }

    public void setup(String url) {
        for (DisposableBean disposableBean : this.beansToClose) {
            try {
                disposableBean.destroy();
            }
            catch (Throwable throwable) {}
        }
        this.beansToClose.clear();
        this.semaphoreService = null;
        if (url.toLowerCase().startsWith("http://") || url.toLowerCase().startsWith("https://")) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting up HTTP invoker");
            }
        } else {
            throw new RuntimeException("Unsupported protocol for URL " + url);
        }
        HttpInvokerProxyFactoryBean factoryBean = new HttpInvokerProxyFactoryBean();
        factoryBean.setServiceUrl(url + "/SemaphoreService");
        factoryBean.setServiceInterface(SemaphoreService.class);
        factoryBean.setHttpInvokerRequestExecutor(this.httpInvokerRequestExecutor);
        factoryBean.afterPropertiesSet();
        this.semaphoreService = (SemaphoreService)factoryBean.getObject();
    }

    public boolean checkLogin(Credentials credentials) throws ServiceException {
        if (this.semaphoreService == null) {
            throw new RuntimeException("Not connected");
        }
        return this.semaphoreService.checkLogin(credentials);
    }

    public TatamiFightData getTatamiFightData(Credentials credentials) throws ServiceException {
        if (this.semaphoreService == null) {
            throw new RuntimeException("Not connected");
        }
        return this.semaphoreService.getTatamiFightData(credentials);
    }
}

