/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.restclient;

import java.util.Map;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import si.nevensrok.common.restclient.RestApiException;
import si.nevensrok.common.restclient.RestApiResponseException;
import si.nevensrok.common.restclient.RestClient;
import si.nevensrok.common.restclient.RestClientUtil;
import si.nevensrok.common.restclient.RestRequest;
import si.nevensrok.common.restclient.RestResponse;
import si.nevensrok.common.utils.StringUtil;

public class JsonRestClient
extends RestClient {
    private String mimeType = "application/json";
    private String charset = "utf8";
    private ObjectMapper objectMapper = new ObjectMapper();

    public JsonRestClient() {
        this.objectMapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public <V> void executeAsJson(String method, String url) {
        this.executeAsJson(method, url, null, null, null);
    }

    public <K> void executeAsJson(String method, String url, K body) {
        this.executeAsJson(method, url, body, null, null);
    }

    public <K> void executeAsJson(String method, String url, K body, Map<String, String> queryParameters) {
        this.executeAsJson(method, url, body, queryParameters, null);
    }

    public <K> void executeAsJson(String method, String url, K body, Map<String, String> queryParameters, Map<String, String> headers) {
        RestResponse restResponse;
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(method);
        restRequest.setUrl(url);
        if (queryParameters != null) {
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                restRequest.setQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                restRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (body != null) {
            String contentType = this.getContentType();
            String charset = RestClientUtil.extractCharset(contentType);
            if (StringUtil.isEmpty((String)charset)) {
                charset = "utf8";
            }
            restRequest.setContentType(contentType);
            try {
                String json = this.getObjectMapper().writeValueAsString(body);
                restRequest.setBody(json.getBytes(charset));
            }
            catch (Exception e) {
                throw new RestApiException("Error serializing json", e);
            }
        }
        if (!(restResponse = this.execute(restRequest)).isSuccessful()) {
            throw new RestApiResponseException("Error response code received " + restResponse.getResponseCode(), restResponse.getResponseCode());
        }
    }

    public <V> V executeAndReadAsJson(String method, String url, Class<V> responseClass) {
        return this.executeAndReadAsJson(method, url, null, null, null, responseClass);
    }

    public <K, V> V executeAndReadAsJson(String method, String url, K body, Class<V> responseClass) {
        return this.executeAndReadAsJson(method, url, body, null, null, responseClass);
    }

    public <K, V> V executeAndReadAsJson(String method, String url, K body, Map<String, String> queryParameters, Class<V> responseClass) {
        return this.executeAndReadAsJson(method, url, body, queryParameters, null, responseClass);
    }

    public <K, V> V executeAndReadAsJson(String method, String url, K body, Map<String, String> queryParameters, Map<String, String> headers, Class<V> responseClass) {
        RestResponse restResponse;
        String json;
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(method);
        restRequest.setUrl(url);
        if (queryParameters != null) {
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                restRequest.setQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                restRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (body != null) {
            String contentType = this.getContentType();
            String charset = RestClientUtil.extractCharset(contentType);
            if (StringUtil.isEmpty((String)charset)) {
                charset = "utf8";
            }
            restRequest.setContentType(contentType);
            try {
                json = this.getObjectMapper().writeValueAsString(body);
                restRequest.setBody(json.getBytes(charset));
            }
            catch (Exception e) {
                throw new RestApiException("Error serializing json", e);
            }
        }
        if (!(restResponse = this.execute(restRequest)).isSuccessful()) {
            throw new RestApiResponseException("Error response code received " + restResponse.getResponseCode(), restResponse.getResponseCode());
        }
        if (!this.acceptResponseContentType(restResponse.getContentType())) {
            throw new RestApiException("Invalid response content type: '" + restResponse.getContentType() + "'");
        }
        if (restResponse.getBody() == null || restResponse.getBody().length == 0) {
            return null;
        }
        try {
            String responseCharset = restResponse.getCharset();
            if (StringUtil.isEmpty((String)responseCharset)) {
                responseCharset = "utf8";
            }
            json = new String(restResponse.getBody(), responseCharset);
            Object responseBody = this.getObjectMapper().readValue(json, responseClass);
            return (V)responseBody;
        }
        catch (Exception e) {
            throw new RestApiException("Error parsing response body as json", e);
        }
    }

    private boolean acceptResponseContentType(String contentType) {
        if (StringUtil.isEmpty((String)contentType)) {
            return false;
        }
        if (contentType.toLowerCase().startsWith("application/json")) {
            return true;
        }
        return contentType.toLowerCase().startsWith("text/json");
    }

    public String getContentType() {
        if (StringUtil.isNotEmpty((String)this.getMimeType()) && StringUtil.isNotEmpty((String)this.getCharset())) {
            return this.getMimeType() + "; charset=" + this.getCharset();
        }
        if (StringUtil.isEmpty((String)this.getMimeType()) && StringUtil.isNotEmpty((String)this.getCharset())) {
            return "application/json; charset=" + this.getCharset();
        }
        if (StringUtil.isNotEmpty((String)this.getMimeType()) && StringUtil.isEmpty((String)this.getCharset())) {
            return this.getMimeType() + "; charset=utf8";
        }
        return "application/json; charset=utf8";
    }
}

