/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ldap;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.ldap.LdapClient;

public class LdapClientImpl
implements InitializingBean,
DisposableBean,
LdapClient {
    private static final Logger log = LoggerFactory.getLogger(LdapClientImpl.class);
    private String providerUrl = null;
    private String hostname = null;
    private int port = 389;
    private String username = null;
    private String password = null;
    private String searchBase = null;
    private Hashtable<String, Object> env;
    private LdapContext ldapContext = null;

    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.providerUrl == null && this.hostname == null) {
            throw new IllegalArgumentException("Property 'providerUrl' or 'hostname' is required");
        }
        if (this.searchBase == null) {
            throw new IllegalArgumentException("Property 'searchBase' is required");
        }
        if (this.providerUrl == null) {
            this.providerUrl = "ldap://" + this.hostname + ":" + this.port;
            log.debug("Generated provider url: [{}]", (Object)this.providerUrl);
        }
        this.env = new Hashtable();
        this.env.put("java.naming.security.authentication", "simple");
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.env.put("java.naming.provider.url", this.providerUrl);
        if (this.username != null) {
            this.env.put("java.naming.security.principal", this.username);
        }
        if (this.password != null) {
            this.env.put("java.naming.security.credentials", this.password);
        }
        this.ldapContext = new InitialLdapContext(this.env, null);
    }

    public void destroy() throws Exception {
        try {
            this.ldapContext.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<SearchResult> search(String searchFilter) {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        return this.search(this.searchBase, searchFilter, searchControls);
    }

    @Override
    public List<SearchResult> search(String searchBase, String searchFilter) {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        return this.search(searchBase, searchFilter, searchControls);
    }

    @Override
    public List<SearchResult> search(String searchFilter, SearchControls searchControls) {
        return this.search(this.searchBase, searchFilter, searchControls);
    }

    @Override
    public List<SearchResult> search(String searchBase, String searchFilter, SearchControls searchControls) {
        try {
            LinkedList<SearchResult> searchResults = new LinkedList<SearchResult>();
            NamingEnumeration<SearchResult> results = this.ldapContext.search(searchBase, searchFilter, searchControls);
            while (results.hasMore()) {
                SearchResult searchResult = results.next();
                searchResults.add(searchResult);
            }
            return searchResults;
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing ldap search", e);
        }
    }
}

