/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.keystore;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Map;
import si.nevensrok.common.x509cert.CertificateUtil;
import si.nevensrok.common.x509cert.KeyUtil;
import sun.security.x509.X509CertImpl;

public class KeyStoreUtil {
    public static KeyStore generateEmpty() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, new char[0]);
        return keyStore;
    }

    public static KeyStore loadFromInputStream(InputStream inputStream, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(inputStream, password.toCharArray());
        return keyStore;
    }

    public static KeyStore generateFromCertificateAndPrivateKey(String alias, Certificate certificate, PrivateKey privateKey, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, new char[0]);
        keyStore.setCertificateEntry(alias, certificate);
        keyStore.setKeyEntry(alias, privateKey, password.toCharArray(), new Certificate[]{certificate});
        return keyStore;
    }

    public static KeyStore generateFromCertificate(String alias, Certificate certificate) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, new char[0]);
        keyStore.setCertificateEntry(alias, certificate);
        return keyStore;
    }

    public static KeyStore generateFromCertificates(Map<String, Certificate> certificates) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, new char[0]);
        for (Map.Entry<String, Certificate> entry : certificates.entrySet()) {
            keyStore.setCertificateEntry(entry.getKey(), entry.getValue());
        }
        return keyStore;
    }

    public static KeyStore generateFromCertificateAndPrivateKeyStreams(String alias, InputStream certificateStream, InputStream privateKeyStream, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, new char[0]);
        X509CertImpl certificate = CertificateUtil.loadCertificate(certificateStream);
        if (certificate == null) {
            throw new RuntimeException("Error loading certificate");
        }
        keyStore.setCertificateEntry(alias, certificate);
        PrivateKey privateKey = KeyUtil.loadPrivateKey(privateKeyStream);
        if (privateKey == null) {
            throw new RuntimeException("Error loading private key");
        }
        keyStore.setKeyEntry(alias, privateKey, password.toCharArray(), new Certificate[]{certificate});
        return keyStore;
    }

    public static KeyStore generateFromCertificateStream(String alias, InputStream certificateStream) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, new char[0]);
        X509CertImpl certificate = CertificateUtil.loadCertificate(certificateStream);
        if (certificate == null) {
            throw new RuntimeException("Error loading certificate");
        }
        keyStore.setCertificateEntry(alias, certificate);
        return keyStore;
    }
}

