/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache.memory;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.cache.Cache;
import si.nevensrok.common.cache.AbstractCacheManager;
import si.nevensrok.common.cache.CacheSettings;
import si.nevensrok.common.cache.memory.MemoryCache;

public class MemoryCacheManager
extends AbstractCacheManager {
    private Map<String, MemoryCache> cacheStore = new LinkedHashMap<String, MemoryCache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(String name) {
        MemoryCache cache;
        Map<String, MemoryCache> map = this.cacheStore;
        synchronized (map) {
            cache = this.cacheStore.get(name);
            if (cache == null) {
                CacheSettings settings = this.getCacheSettings().get(name);
                if (settings == null) {
                    settings = this.getDefaultCacheSettings();
                }
                cache = new MemoryCache(name, settings);
                this.cacheStore.put(name, cache);
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCacheNames() {
        Map<String, MemoryCache> map = this.cacheStore;
        synchronized (map) {
            return new LinkedList<String>(this.cacheStore.keySet());
        }
    }
}

