/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache.memory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.cache.AbstractCache;
import si.nevensrok.common.cache.CacheSettings;
import si.nevensrok.common.cache.CachedValue;

public class MemoryCache
extends AbstractCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryCache.class);
    private Map<Object, CachedValue> cache = new HashMap<Object, CachedValue>();

    public MemoryCache(String name, CacheSettings cacheSettings) {
        super(name, cacheSettings);
    }

    @Override
    public synchronized CachedValue get(Object key) {
        CachedValue cachedValue = this.cache.get(key);
        if (cachedValue != null && !this.isCacheValid(cachedValue)) {
            cachedValue = null;
        }
        return cachedValue;
    }

    public synchronized void put(Object key, Object value) {
        if (value instanceof Serializable || value == null) {
            CachedValue cachedValue = new CachedValue(value, this.generateValidUntil());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Adding to cache: {} -> {}", new Object[]{key, cachedValue});
            }
            this.cache.put(key, cachedValue);
            if (this.getCacheSettings().getMaxElements() != null && this.getCacheSettings().getMaxElements() > 0) {
                int maxElementsBeforeCleanup = Math.round(this.getCacheSettings().getMaxElements().floatValue() * 1.2f);
                if (this.cache.size() > maxElementsBeforeCleanup) {
                    this.cleanup();
                }
            }
        }
    }

    @Override
    public synchronized CachedValue putIfAbsent(Object key, Object value) {
        return super.putIfAbsent(key, value);
    }

    public synchronized void evict(Object key) {
        LOGGER.trace("Evicting key {}", key);
        this.cache.remove(key);
    }

    public synchronized void clear() {
        LOGGER.trace("Clearing cache");
        this.cache.clear();
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void cleanup() {
        int itemsToRemove;
        LOGGER.trace("Cache cleanup");
        HashSet<Object> keysToRemove = new HashSet<Object>();
        ArrayList<Map.Entry<Object, CachedValue>> entries = new ArrayList<Map.Entry<Object, CachedValue>>(this.cache.size());
        for (Map.Entry<Object, CachedValue> entry : this.cache.entrySet()) {
            if (!this.isCacheValid(entry.getValue())) {
                keysToRemove.add(entry.getKey());
                continue;
            }
            entries.add(entry);
        }
        for (Map.Entry<Object, CachedValue> entry : keysToRemove) {
            this.cache.remove(entry);
        }
        if (this.getCacheSettings().getMaxElements() != null && this.getCacheSettings().getMaxElements() > 0 && (itemsToRemove = this.cache.size() - this.getCacheSettings().getMaxElements()) > 0) {
            void var4_9;
            Collections.sort(entries, new Comparator<Map.Entry<Object, CachedValue>>(){

                @Override
                public int compare(Map.Entry<Object, CachedValue> o1, Map.Entry<Object, CachedValue> o2) {
                    return Long.compare(o1.getValue().getCreatedAt(), o2.getValue().getCreatedAt());
                }
            });
            boolean bl = false;
            while (var4_9 < itemsToRemove) {
                this.cache.remove(((Map.Entry)entries.get((int)var4_9)).getKey());
                ++var4_9;
            }
        }
    }
}

