/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.fightinfo.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.ClassPathResource;
import si.nevensrok.jtekma.common.fightinfo.CurrentMatchInfo;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.MatchDetail;
import si.nevensrok.jtekma.common.tatami.TatamiFightData;
import si.nevensrok.jtekma.fightinfo.common.FightWindowData;
import si.nevensrok.jtekma.fightinfo.fw.FightInfoManager;
import si.nevensrok.jtekma.fightinfo.gui.FightDataMiniWindow;
import si.nevensrok.jtekma.fightinfo.gui.FightLineTable;
import si.nevensrok.jtekma.fightinfo.gui.NextFightsPanel;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.utils.gui.CredentialsDialog;

public class FightInfoWindow
extends JFrame
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static final long serialVersionUID = -8030908599445704172L;
    private static final Logger log = LoggerFactory.getLogger(FightInfoWindow.class);
    private boolean isConnected = false;
    private ApplicationContext applicationContext;
    private String defaultServiceUrl = null;
    private boolean broadcasterEnable = false;
    private int broadcasterPort = 12701;
    private FightInfoManager fightInfoManager;
    private RulesManager rulesManager;
    private Locale locale = Locale.getDefault();
    private JMenuItem connectMenuItem;
    private JMenuItem disconnectMenuItem;
    private JTabbedPane mainTabbedPane;
    private FightLineTable fightLinePanelTable;
    private NextFightsPanel nextFightsPanel;
    private Map<Long, FightDataMiniWindow> fightDataMiniWindows = new HashMap<Long, FightDataMiniWindow>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setDefaultServiceUrl(String defaultServiceUrl) {
        this.defaultServiceUrl = defaultServiceUrl;
    }

    public void setBroadcasterEnable(boolean broadcasterEnable) {
        this.broadcasterEnable = broadcasterEnable;
    }

    public void setBroadcasterPort(int broadcasterPort) {
        this.broadcasterPort = broadcasterPort;
    }

    public void setFightInfoManager(FightInfoManager fightInfoManager) {
        this.fightInfoManager = fightInfoManager;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.locale);
    }

    public FightInfoWindow() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FightInfoWindow.this.closeApplication();
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        final FightInfoWindow window = this;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FightInfoWindow.this.setTitle("JTekma2 - " + FightInfoWindow.this.getLanguageText("window.title"));
                FightInfoWindow.this.setSize(1024, 768);
                FightInfoWindow.this.setLocationByPlatform(true);
                JMenuBar menuBar = new JMenuBar();
                FightInfoWindow.this.setJMenuBar(menuBar);
                JMenu connectionMenu = new JMenu(FightInfoWindow.this.getLanguageText("menu.connection"));
                menuBar.add(connectionMenu);
                FightInfoWindow.this.connectMenuItem = new JMenuItem(FightInfoWindow.this.getLanguageText("menu.connect"));
                FightInfoWindow.this.connectMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String buildVersion = "";
                        ClassPathResource gitFileResurce = new ClassPathResource("/git.properties");
                        if (gitFileResurce.exists()) {
                            try {
                                Properties properties = new Properties();
                                properties.load(gitFileResurce.getInputStream());
                                buildVersion = (String)properties.get("git.commit.id.describe");
                            }
                            catch (Exception ex) {
                                log.debug("Error reading git build info", (Throwable)ex);
                            }
                        }
                        try {
                            Credentials credentials;
                            HashMap<String, String> messages = new HashMap<String, String>();
                            messages.put("title", FightInfoWindow.this.getLanguageText("login.title"));
                            messages.put("url", FightInfoWindow.this.getLanguageText("login.url"));
                            messages.put("username", FightInfoWindow.this.getLanguageText("login.username"));
                            messages.put("password", FightInfoWindow.this.getLanguageText("login.password"));
                            messages.put("login", FightInfoWindow.this.getLanguageText("login.login"));
                            messages.put("cancel", FightInfoWindow.this.getLanguageText("login.cancel"));
                            messages.put("buildVersion", FightInfoWindow.this.getLanguageText("login.version"));
                            messages.put("buildVersionDisplay", buildVersion);
                            messages.put("defaultServiceUrl", FightInfoWindow.this.defaultServiceUrl);
                            if (FightInfoWindow.this.broadcasterEnable) {
                                messages.put("broadcaster.port", String.valueOf(FightInfoWindow.this.broadcasterPort));
                            }
                            if ((credentials = CredentialsDialog.showDialog((Frame)window, messages)) != null) {
                                if (FightInfoWindow.this.fightInfoManager.connect(credentials)) {
                                    FightInfoWindow.this.changeConnectOptions(true);
                                    JOptionPane.showMessageDialog(window, FightInfoWindow.this.getLanguageText("login.loginSuccess"), FightInfoWindow.this.getLanguageText("title.info"), 1);
                                } else {
                                    JOptionPane.showMessageDialog(window, FightInfoWindow.this.getLanguageText("login.invalidCredentials"), FightInfoWindow.this.getLanguageText("title.error"), 0);
                                }
                            }
                        }
                        catch (Exception ex) {
                            log.error("Error while cheking login", (Throwable)ex);
                            JOptionPane.showMessageDialog(window, FightInfoWindow.this.getLanguageText("login.errorConnectionToServer"), FightInfoWindow.this.getLanguageText("title.error"), 0);
                        }
                    }
                });
                connectionMenu.add(FightInfoWindow.this.connectMenuItem);
                FightInfoWindow.this.disconnectMenuItem = new JMenuItem(FightInfoWindow.this.getLanguageText("menu.disconnect"));
                FightInfoWindow.this.disconnectMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FightInfoWindow.this.fightInfoManager.disconnect();
                        FightInfoWindow.this.changeConnectOptions(false);
                    }
                });
                connectionMenu.add(FightInfoWindow.this.disconnectMenuItem);
                connectionMenu.addSeparator();
                JMenuItem closeMenuItem = new JMenuItem(FightInfoWindow.this.getLanguageText("menu.exit"));
                connectionMenu.add(closeMenuItem);
                closeMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FightInfoWindow.this.closeApplication();
                    }
                });
                FightInfoWindow.this.setLayout(new BorderLayout());
                FightInfoWindow.this.mainTabbedPane = new JTabbedPane();
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                FightInfoWindow.this.fightLinePanelTable = new FightLineTable(FightInfoWindow.this.applicationContext, FightInfoWindow.this.locale);
                panel.add((Component)FightInfoWindow.this.fightLinePanelTable, "North");
                FightInfoWindow.this.mainTabbedPane.add(FightInfoWindow.this.getLanguageText("tabs.fightList"), new JScrollPane(panel));
                panel = new JPanel();
                panel.setLayout(new BorderLayout());
                FightInfoWindow.this.nextFightsPanel = new NextFightsPanel();
                panel.add((Component)FightInfoWindow.this.nextFightsPanel, "North");
                FightInfoWindow.this.mainTabbedPane.add(FightInfoWindow.this.getLanguageText("tabs.fightDataLines"), new JScrollPane(panel));
                FightInfoWindow.this.setVisible(true);
                FightInfoWindow.this.changeConnectOptions(false);
            }
        });
    }

    public void destroy() throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FightInfoWindow.this.setVisible(false);
                FightInfoWindow.this.dispose();
            }
        });
    }

    private void closeApplication() {
        final FightInfoWindow window = this;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (JOptionPane.showConfirmDialog(window, FightInfoWindow.this.getLanguageText("closing.text"), FightInfoWindow.this.getLanguageText("closing.title"), 1, 3) == 0) {
                    FightInfoWindow.this.setVisible(false);
                    Thread closeThread = new Thread("Close thread"){

                        @Override
                        public void run() {
                            if (FightInfoWindow.this.applicationContext instanceof AbstractApplicationContext) {
                                AbstractApplicationContext abstractApplicationContext = (AbstractApplicationContext)FightInfoWindow.this.applicationContext;
                                abstractApplicationContext.close();
                            } else {
                                log.warn("Can't destroy application context. Stopping java proccess");
                            }
                            System.exit(0);
                        }
                    };
                    closeThread.start();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeConnectOptions(boolean connected) {
        this.isConnected = connected;
        if (connected) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FightInfoWindow.this.add((Component)FightInfoWindow.this.mainTabbedPane, "Center");
                    FightInfoWindow.this.connectMenuItem.setEnabled(false);
                    FightInfoWindow.this.disconnectMenuItem.setEnabled(true);
                    FightInfoWindow.this.revalidate();
                    FightInfoWindow.this.repaint();
                }
            });
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FightInfoWindow.this.remove(FightInfoWindow.this.mainTabbedPane);
                    FightInfoWindow.this.connectMenuItem.setEnabled(true);
                    FightInfoWindow.this.disconnectMenuItem.setEnabled(false);
                    FightInfoWindow.this.revalidate();
                    FightInfoWindow.this.repaint();
                }
            });
            Map<Long, FightDataMiniWindow> map = this.fightDataMiniWindows;
            synchronized (map) {
                for (final FightDataMiniWindow fightDataMiniWindow : this.fightDataMiniWindows.values()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            fightDataMiniWindow.setVisible(false);
                            fightDataMiniWindow.dispose();
                        }
                    });
                }
                this.fightDataMiniWindows.clear();
            }
            this.updateMiniWindowDispay();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFightLineTable(List<CurrentMatchInfo> currentMatchInfoList) {
        if (!this.isConnected) {
            return;
        }
        this.fightLinePanelTable.updateFightLineTable(currentMatchInfoList);
        this.updateMiniWindowDispay();
        for (CurrentMatchInfo currentMatchInfo : currentMatchInfoList) {
            MatchDetail matchDetail = currentMatchInfo.getMatchDetail();
            FightDataMiniWindow fightDataMiniWindow = null;
            Map<Long, FightDataMiniWindow> map = this.fightDataMiniWindows;
            synchronized (map) {
                fightDataMiniWindow = this.fightDataMiniWindows.get(currentMatchInfo.getTatami().getTatamiId());
            }
            if (fightDataMiniWindow == null) continue;
            fightDataMiniWindow.updateContent(matchDetail, currentMatchInfo.getRules(), this.rulesManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMiniWindowDispay() {
        List<FightWindowData> fightWindowDatas = this.fightLinePanelTable.getFightWindowDatas();
        Map<Long, FightDataMiniWindow> map = this.fightDataMiniWindows;
        synchronized (map) {
            HashSet<Long> unusedWindows = new HashSet<Long>(this.fightDataMiniWindows.keySet());
            if (this.isConnected) {
                for (FightWindowData fightWindowData : fightWindowDatas) {
                    Long tatamiId = fightWindowData.getTatami().getTatamiId();
                    if (!fightWindowData.isDisplayWindow()) continue;
                    FightDataMiniWindow fightDataMiniWindow = this.fightDataMiniWindows.get(tatamiId);
                    if (fightDataMiniWindow == null) {
                        fightDataMiniWindow = new FightDataMiniWindow();
                        this.fightDataMiniWindows.put(tatamiId, fightDataMiniWindow);
                    } else {
                        unusedWindows.remove(tatamiId);
                    }
                    fightDataMiniWindow.updateLocationAndSize(fightWindowData);
                }
            }
            for (Long tatamiId : unusedWindows) {
                final FightDataMiniWindow fightDataMiniWindow = this.fightDataMiniWindows.remove(tatamiId);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        fightDataMiniWindow.setVisible(false);
                        fightDataMiniWindow.dispose();
                    }
                });
            }
        }
    }

    public void updateTatamiNextFights(TatamiFightData tatamiFightData) {
        if (!this.isConnected) {
            return;
        }
        this.nextFightsPanel.updateTatamiNextFights(tatamiFightData);
    }
}

