/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class ByteUtil {
    private ByteUtil() {
    }

    public static String toHexString(byte[] data) {
        if (data == null) {
            return null;
        }
        StringBuilder text = new StringBuilder();
        for (byte b : data) {
            int n = b & 0xFF;
            if (n < 16) {
                text.append("0");
            }
            text.append(Integer.toHexString(n).toUpperCase());
        }
        return text.toString();
    }

    public static byte[] fromHexString(String text) {
        if (text == null) {
            return null;
        }
        try {
            byte[] data = new byte[text.length() / 2];
            for (int i = 0; i < data.length; ++i) {
                byte b;
                String part = text.substring(i * 2, i * 2 + 2);
                data[i] = b = (byte)Integer.parseInt(part, 16);
            }
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException("Error decoding HEX string", e);
        }
    }

    public static String toBase64String(byte[] data) {
        BASE64Encoder encoder = new BASE64Encoder();
        String text = encoder.encodeBuffer(data);
        return text.trim();
    }

    public static byte[] fromBase64String(String text) {
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] data = decoder.decodeBuffer(text);
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException("Error decoding base64 string", e);
        }
    }
}

