/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.request;

import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import si.nevensrok.common.request.Callback;
import si.nevensrok.common.request.FutureResult;
import si.nevensrok.common.request.RequestExecutor;
import si.nevensrok.common.threads.ThreadUtil;

public abstract class AbstractSyncRequestExecutor<R, S>
implements RequestExecutor<R, S> {
    private Executor executor = null;

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public abstract S executeSync(R var1) throws Throwable;

    @Override
    public Future<S> executeAsync(R request) {
        FutureResult futureResult = new FutureResult();
        this.executeAsync(request, futureResult);
        return futureResult;
    }

    @Override
    public void executeAsync(final R request, final Callback<S> callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Object response = AbstractSyncRequestExecutor.this.executeSync(request);
                    callback.success(response);
                }
                catch (Throwable e) {
                    callback.error(e);
                }
            }
        };
        if (this.executor != null) {
            this.executor.execute(runnable);
        } else {
            ThreadUtil.runInBackground(runnable);
        }
    }
}

