/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientProtocol;
import si.nevensrok.common.network.tcp.CustomTlsClient;
import si.nevensrok.common.network.tcp.TcpNetworkClient;
import si.nevensrok.common.network.tcp.TcpNetworkConnection;
import si.nevensrok.common.ssl.BcCertificateHostnameVerifier;
import si.nevensrok.common.ssl.BcHostnameVerifier;
import si.nevensrok.common.ssl.BcKeyManager;
import si.nevensrok.common.ssl.BcTrustManager;

public class BcSslTcpNetworkClient
extends TcpNetworkClient {
    private BcKeyManager keyManager;
    private BcTrustManager trustManager;
    private BcHostnameVerifier hostnameVerifier = null;
    private boolean checkHostname = true;

    public void setKeyManager(BcKeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setTrustManager(BcTrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void setHostnameVerifier(BcHostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setCheckHostname(boolean checkHostname) {
        this.checkHostname = checkHostname;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.trustManager == null) {
            throw new IllegalArgumentException("Property 'trustManager' is required");
        }
        if (this.hostnameVerifier == null) {
            this.hostnameVerifier = new BcCertificateHostnameVerifier();
        }
        super.afterPropertiesSet();
    }

    @Override
    protected TcpNetworkConnection openTcpNetworkConnection(Socket socket) throws Exception {
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        CustomTlsClient tlsClient = new CustomTlsClient();
        tlsClient.setKeyManager(this.keyManager);
        tlsClient.setTrustManager(this.trustManager);
        TlsClientProtocol tlsClientProtocol = new TlsClientProtocol(inputStream, outputStream);
        tlsClientProtocol.connect((TlsClient)tlsClient);
        if (tlsClient.isSslSessionValid()) {
            if (this.checkHostname) {
                Certificate certificate = Certificate.getInstance((Object)tlsClient.getServerCertificate().getEncoded());
                if (!this.hostnameVerifier.verify(this.getAddress(), certificate)) {
                    throw new RuntimeException("Hostname verification failed");
                }
            }
            OutputStream socketOutputStream = tlsClientProtocol.getOutputStream();
            InputStream socketInputStream = tlsClientProtocol.getInputStream();
            return new TcpNetworkConnection(socket, socketInputStream, socketOutputStream);
        }
        throw new IOException("Ssl session is invalid");
    }
}

