/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dl.query;

import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.objects.ObjectEquals;
import si.nevensrok.common.objects.ObjectHash;
import si.nevensrok.common.objects.ObjectToString;

public class SimpleDataFilter
implements DataFilter {
    private static final long serialVersionUID = 8215277896127413442L;
    private Integer startIndex;
    private Integer itemLimit;
    private Filter filter;
    private Sort sort;
    private boolean fetchCount = true;
    private boolean fetchList = true;
    private boolean fetchHasMore = false;

    public SimpleDataFilter() {
    }

    public SimpleDataFilter(SimpleDataFilter other) {
        this.startIndex = other.startIndex;
        this.itemLimit = other.itemLimit;
        this.filter = other.filter;
        this.sort = other.sort;
        this.fetchCount = other.fetchCount;
        this.fetchList = other.fetchList;
        this.fetchHasMore = other.fetchHasMore;
    }

    public SimpleDataFilter(Filter filter) {
        this.filter = filter;
    }

    public SimpleDataFilter(Integer startIndex, Integer itemLimit, Filter filter) {
        this.startIndex = startIndex;
        this.itemLimit = itemLimit;
        this.filter = filter;
    }

    public SimpleDataFilter(Integer startIndex, Integer itemLimit, Filter filter, Sort sort) {
        this.startIndex = startIndex;
        this.itemLimit = itemLimit;
        this.filter = filter;
        this.sort = sort;
    }

    @Override
    public Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    @Override
    public Integer getItemLimit() {
        return this.itemLimit;
    }

    public void setItemLimit(Integer itemLimit) {
        this.itemLimit = itemLimit;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    @Override
    public boolean isFetchTotalCount() {
        return this.fetchCount;
    }

    public void setFetchCount(boolean fetchCount) {
        this.fetchCount = fetchCount;
    }

    @Override
    public boolean isFetchList() {
        return this.fetchList;
    }

    public void setFetchList(boolean fetchList) {
        this.fetchList = fetchList;
    }

    @Override
    public boolean isFetchHasMore() {
        return this.fetchHasMore;
    }

    public void setFetchHasMore(boolean fetchHasMore) {
        this.fetchHasMore = fetchHasMore;
    }

    public void setPage(int page) {
        if (page < 1) {
            throw new IllegalArgumentException("Argument 'page' must be value bigger on equal to 1");
        }
        if (this.itemLimit == null) {
            throw new IllegalArgumentException("Property 'itemLimit' is not set");
        }
        this.startIndex = (page - 1) * this.itemLimit;
    }

    public void setItemCountPerPage(int itemCountPerPage) {
        this.setItemLimit(itemCountPerPage);
    }

    public int hashCode() {
        return new ObjectHash().addValue(this.fetchCount).addValue(this.fetchHasMore).addValue(this.fetchList).addValue((Object)this.filter).addValue((Object)this.itemLimit).addValue((Object)this.sort).addValue((Object)this.startIndex).calculateHash();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleDataFilter) {
            SimpleDataFilter other = (SimpleDataFilter)obj;
            return new ObjectEquals().addValue(this.fetchCount, other.fetchCount).addValue(this.fetchHasMore, other.fetchHasMore).addValue(this.fetchList, other.fetchList).addValue((Object)this.filter, (Object)other.filter).addValue((Object)this.itemLimit, (Object)other.itemLimit).addValue((Object)this.sort, (Object)other.sort).addValue((Object)this.startIndex, (Object)other.startIndex).calculateEquals();
        }
        return false;
    }

    public String toString() {
        return new ObjectToString(SimpleDataFilter.class).addProperty("startIndex", (Object)this.startIndex).addProperty("itemLimit", (Object)this.itemLimit).addProperty("filter", (Object)this.filter).addProperty("sort", (Object)this.sort).addProperty("fetchCount", this.fetchCount).addProperty("fetchList", this.fetchList).addProperty("fetchHasMore", this.fetchHasMore).generateString();
    }
}

