/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.ssl.CertificateAndKeyRepository;
import si.nevensrok.common.ssl.CertificateRepository;
import si.nevensrok.common.ssl.CustomKeyManager;
import si.nevensrok.common.ssl.CustomTrustManager;
import si.nevensrok.common.ssl.KeystoreTrustManager;
import si.nevensrok.common.ssl.SslContextGenerator;

public class CustomSslContextGenerator
implements SslContextGenerator,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(CustomSslContextGenerator.class);
    private String protocol = "TLS";
    private SSLContext sslContext;
    private X509TrustManager trustManager;
    private X509KeyManager keyManager;
    private SSLContext oldSslContext = null;
    private boolean overrideDefault = false;
    private boolean trustAll = false;
    private boolean checkDate = true;
    private CertificateAndKeyRepository keyRepository;
    private CertificateRepository trustStoreRepository;

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setOverrideDefault(boolean overrideDefault) {
        this.overrideDefault = overrideDefault;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public void setCheckDate(boolean checkDate) {
        this.checkDate = checkDate;
    }

    public void setKeyRepository(CertificateAndKeyRepository keyRepository) {
        this.keyRepository = keyRepository;
    }

    public void setTrustStoreRepository(CertificateRepository trustStoreRepository) {
        this.trustStoreRepository = trustStoreRepository;
    }

    protected X509KeyManager generateKeyManager() {
        if (this.keyRepository != null) {
            return new CustomKeyManager(this.keyRepository);
        }
        return null;
    }

    protected X509TrustManager generateTrustManager() {
        if (this.trustStoreRepository != null) {
            return new CustomTrustManager(this.trustStoreRepository);
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.sslContext = SSLContext.getInstance(this.protocol);
            this.keyManager = this.generateKeyManager();
            if (this.keyManager instanceof CustomKeyManager) {
                ((CustomKeyManager)this.keyManager).setCheckDate(this.checkDate);
                ((CustomKeyManager)this.keyManager).setCheckWithDateGracePeriod(this.checkDate);
            }
            if (this.trustAll) {
                this.trustManager = new CustomTrustManager(true);
            } else {
                this.trustManager = this.generateTrustManager();
                if (this.trustManager == null) {
                    this.trustManager = new KeystoreTrustManager();
                }
            }
            if (this.trustManager instanceof CustomTrustManager) {
                ((CustomTrustManager)this.trustManager).setCheckDate(this.checkDate);
            }
            KeyManager[] keyManagerList = new KeyManager[]{this.keyManager};
            TrustManager[] trustManagerList = new TrustManager[]{this.trustManager};
            SecureRandom secureRandom = new SecureRandom();
            this.sslContext.init(keyManagerList, trustManagerList, secureRandom);
            if (this.overrideDefault) {
                this.oldSslContext = SSLContext.getDefault();
                log.info("Overriding default SSL context");
                SSLContext.setDefault(this.sslContext);
            }
        }
        catch (Exception e) {
            log.error("Error initializing SSL Context", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        if (this.overrideDefault && this.oldSslContext != null) {
            log.info("Reverting default SSL context");
            SSLContext.setDefault(this.oldSslContext);
        }
    }

    @Override
    public SSLContext generateSSLContext() {
        return this.sslContext;
    }

    public X509KeyManager getKeyManager() {
        return this.keyManager;
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }
}

