/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.util.List;
import org.bouncycastle.asn1.x509.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.bccert.BcCertificateUtil;
import si.nevensrok.common.ssl.BcHostnameVerifier;
import si.nevensrok.common.utils.RegexUtil;

public class BcCertificateHostnameVerifier
implements BcHostnameVerifier {
    private static final Logger log = LoggerFactory.getLogger(BcCertificateHostnameVerifier.class);
    private boolean allowAll = false;
    private boolean allowWildmarks = true;

    public BcCertificateHostnameVerifier() {
    }

    public BcCertificateHostnameVerifier(boolean allowAll) {
        this.allowAll = allowAll;
    }

    public BcCertificateHostnameVerifier(boolean allowAll, boolean allowWildmarks) {
        this.allowAll = allowAll;
        this.allowWildmarks = allowWildmarks;
    }

    @Override
    public boolean verify(String hostname, Certificate certificate) {
        if (this.allowAll) {
            return true;
        }
        try {
            try {
                List<String> alternativeNames = BcCertificateUtil.getAlternativeNames(certificate);
                for (String alternativeName : alternativeNames) {
                    if (this.allowWildmarks) {
                        String regex = RegexUtil.createWildcardRegex((String)alternativeName);
                        if (!hostname.toLowerCase().matches(regex.toLowerCase())) continue;
                        return true;
                    }
                    if (!hostname.equalsIgnoreCase(alternativeName)) continue;
                    return true;
                }
            }
            catch (Exception alternativeNames) {
                // empty catch block
            }
            String commonName = BcCertificateUtil.getCommonName(certificate);
            if (this.allowWildmarks) {
                String regex = RegexUtil.createWildcardRegex((String)commonName);
                return hostname.toLowerCase().matches(regex.toLowerCase());
            }
            return hostname.equalsIgnoreCase(commonName);
        }
        catch (Exception e) {
            log.error("Error verifing hostname", (Throwable)e);
            return false;
        }
    }
}

