/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.qrcode.codes;

import java.io.Serializable;
import si.nevensrok.common.qrcode.QRCode;
import si.nevensrok.common.qrcode.QRCodeException;
import si.nevensrok.common.qrcode.QRCodeType;

public class QRUrlCode
implements QRCode,
Serializable {
    private static final long serialVersionUID = 3977231414085244675L;
    private String url;

    public QRUrlCode() {
    }

    public QRUrlCode(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getCodeText() {
        return this.url;
    }

    @Override
    public QRCodeType getType() {
        return QRCodeType.URL;
    }

    @Override
    public void parseCode(String text) throws QRCodeException {
        try {
            if (!text.startsWith("http://") && !text.startsWith("https://")) {
                throw new QRCodeException("Not a URL QR code!");
            }
            this.url = text;
        }
        catch (QRCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QRCodeException("Error while parsing QR code", e);
        }
    }

    public String toString() {
        return "QRUrlCode [url=" + this.url + "]";
    }
}

