/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.streams;

import java.io.IOException;
import java.io.InputStream;
import si.nevensrok.common.encryption.Decryptor;

public class EncryptedInputStream
extends InputStream {
    private InputStream inputStream;
    private Decryptor decryptor;
    private boolean closed = false;
    private byte[] buffer = new byte[0];
    private int bufferPos = 0;
    private int maxMessageSize = 0x10000000;

    public EncryptedInputStream(InputStream inputStream, Decryptor decryptor) {
        this.inputStream = inputStream;
        this.decryptor = decryptor;
    }

    private void readData() throws IOException {
        int n;
        int length = this.readLength();
        byte[] data = new byte[length];
        for (int dataRead = 0; dataRead < length; dataRead += n) {
            n = this.inputStream.read(data, dataRead, length - dataRead);
            if (n >= 0) continue;
            throw new IOException("End of stream reached");
        }
        this.bufferPos = 0;
        this.buffer = this.decryptor.decrypt(data);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        while (this.bufferPos == this.buffer.length) {
            this.readData();
        }
        return this.buffer[this.bufferPos++] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        while (this.bufferPos == this.buffer.length) {
            this.readData();
        }
        int bytesToRead = Math.min(this.buffer.length - this.bufferPos, len);
        System.arraycopy(this.buffer, this.bufferPos, b, off, bytesToRead);
        this.bufferPos += bytesToRead;
        return bytesToRead;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.inputStream.close();
    }

    private int readLength() throws IOException {
        byte[] lengthData = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int n = this.inputStream.read();
            if (n < 0) {
                throw new IOException("End of stream reached");
            }
            lengthData[i] = (byte)n;
        }
        int length = 0;
        length += lengthData[0] & 0xFF;
        length += lengthData[1] << 8 & 0xFF00;
        length += lengthData[2] << 16 & 0xFF0000;
        if ((length += lengthData[3] << 24 & 0xFF000000) > this.maxMessageSize) {
            throw new IOException("Received array length " + length + " is too big");
        }
        return length;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }
}

