/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dataimport;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import si.nevensrok.common.dataimport.FileLine;

public class FileContent
implements Serializable {
    private static final long serialVersionUID = -8307617678638944659L;
    private List<String> headers;
    private List<FileLine> lines;

    public FileContent(List<String> headers, List<FileLine> lines) {
        this.headers = new ArrayList<String>(headers);
        this.lines = new ArrayList<FileLine>(lines);
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public int getIndexOfHeader(String header) {
        int n = 0;
        for (String h : this.headers) {
            if (h.equals(header)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getIndexOfHeader(String[] headerList) {
        for (String h : headerList) {
            int n = this.getIndexOfHeader(h);
            if (n < 0) continue;
            return n;
        }
        return -1;
    }

    public int getIndexOfHeaderCaseInsensitive(String header) {
        int n = 0;
        for (String h : this.headers) {
            if (h.equalsIgnoreCase(header)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getIndexOfHeaderCaseInsensitive(String[] headerList) {
        for (String h : headerList) {
            int n = this.getIndexOfHeaderCaseInsensitive(h);
            if (n < 0) continue;
            return n;
        }
        return -1;
    }

    public String getHeader(int index) {
        return this.headers.get(index);
    }

    public List<FileLine> getLines() {
        return this.lines;
    }

    public FileLine getLine(int index) {
        return this.lines.get(index);
    }

    public String toString() {
        return "FileContent [headers=" + this.headers + ", lines=" + this.lines + "]";
    }
}

