
/* Drop Tables */

DROP TABLE IF EXISTS methodusage;




/* Create Tables */

CREATE TABLE methodusage
(
	Id bigserial NOT NULL,
	UsageDate timestamp with time zone NOT NULL,
	MethodName varchar(4096) NOT NULL,
	BeanName varchar(4096),
	UsageCount int,
	MaxDuration bigint NOT NULL,
	MinDuration bigint NOT NULL,
	AverageDuration bigint NOT NULL,
	PRIMARY KEY (Id)
) WITHOUT OIDS;

/* Create indexes */
CREATE INDEX MethodUsageIndex1 ON methodusage USING BTREE (UsageDate, MethodName, BeanName);

