/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.restclient;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import si.nevensrok.common.map.CaseInsensitiveLinkedHashMap;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.common.restclient.RestApiException;
import si.nevensrok.common.restclient.RestClientUtil;
import si.nevensrok.common.utils.StringUtil;

public class RestRequest
implements Serializable {
    private static final long serialVersionUID = 5632884154308487711L;
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_CONNECT = "CONNECT";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_TRACE = "TRACE";
    public static final String METHOD_PATCH = "PATCH";
    private Integer connectTimeout;
    private Integer readTimeout;
    private String method = "GET";
    private String url;
    private Map<String, List<String>> headers = new CaseInsensitiveLinkedHashMap<List<String>>();
    private Map<String, List<String>> queryParameters = new LinkedHashMap<String, List<String>>();
    private byte[] body;

    public RestRequest() {
    }

    public RestRequest(String url) {
        this.url = url;
    }

    public RestRequest(String method, String url, byte[] body) {
        this.method = method;
        this.url = url;
        this.body = body;
    }

    public RestRequest(String method, String url, Map<String, List<String>> headers, Map<String, List<String>> queryParameters, byte[] body) {
        this.method = method;
        this.url = url;
        if (headers != null) {
            this.headers.putAll(headers);
        }
        if (queryParameters != null) {
            this.queryParameters.putAll(queryParameters);
        }
        this.body = body;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers.clear();
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    public Map<String, List<String>> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, List<String>> queryParameters) {
        this.queryParameters.clear();
        if (queryParameters != null) {
            this.queryParameters.putAll(queryParameters);
        }
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setBody(String body, String contentType) {
        if (body == null) {
            this.body = null;
        } else {
            String charset = null;
            if (StringUtil.isEmpty((String)contentType)) {
                this.setContentType("text/plain; charset=utf-8");
                charset = "utf-8";
            } else {
                this.setContentType(contentType);
                charset = RestClientUtil.extractCharset(contentType);
            }
            if (StringUtil.isEmpty((String)charset)) {
                charset = "utf-8";
            }
            try {
                this.body = body.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RestApiException("Encoding not supported", e);
            }
        }
    }

    public void setWwwFormUrlEncodedBody(Map<String, String> parameters) {
        this.setWwwFormUrlEncodedBody(parameters, "utf8");
    }

    public void setWwwFormUrlEncodedBody(Map<String, String> parameters, String characterEncoding) {
        try {
            StringBuilder body = new StringBuilder();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (body.length() > 0) {
                    body.append("&");
                }
                body.append(URLEncoder.encode(entry.getKey(), characterEncoding));
                if (entry.getValue() == null) continue;
                body.append("=");
                body.append(URLEncoder.encode(entry.getValue(), characterEncoding));
            }
            this.setBody(body.toString(), "application/x-www-form-urlencoded");
        }
        catch (UnsupportedEncodingException e) {
            throw new RestApiException("Encoding not supported", e);
        }
    }

    public void setHeader(String name, String value) {
        if (value == null) {
            this.headers.remove(name);
        } else {
            this.headers.put(name, Arrays.asList(value));
        }
    }

    public void addHeader(String name, String value) {
        if (value == null) {
            return;
        }
        List<String> values = this.headers.get(name);
        if (values == null) {
            values = new LinkedList<String>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    public void setAccept(String accept) {
        this.setHeader("Accept", accept);
    }

    public void setAcceptCharset(String acceptCharset) {
        this.setHeader("Accept-Charset", acceptCharset);
    }

    public void setAcceptEncoding(String acceptEncoding) {
        this.setHeader("Accept-Encoding", acceptEncoding);
    }

    public void setAuthorization(String username, String password) {
        String authString = username + ":" + password;
        byte[] authData = Base64.getEncoder().encode(authString.getBytes(Charset.forName("UTF8")));
        String authorizationBase64 = new String(authData, Charset.forName("UTF8")).trim();
        this.setHeader("Authorization", "Basic " + authorizationBase64);
    }

    public void setContentEncoding(String contentEncoding) {
        this.setHeader("Content-Encoding", contentEncoding);
    }

    public void setContentType(String contentType) {
        this.setHeader("Content-Type", contentType);
    }

    public void addCookie(String cookie) {
        this.addHeader("Cookie", cookie);
    }

    public void setDate(Calendar calendar) {
        if (calendar == null) {
            this.setHeader("Date", null);
        } else {
            this.setHeader("Date", RestClientUtil.formatCalendar(calendar));
        }
    }

    public void setDate(Date date) {
        if (date == null) {
            this.setHeader("Date", null);
        } else {
            this.setHeader("Date", RestClientUtil.formatDate(date));
        }
    }

    public void setHost(String host) {
        this.setHeader("Host", host);
    }

    public void setUserAgent(String userAgent) {
        this.setHeader("User-Agent", userAgent);
    }

    public void setQueryParameter(String name, String value) {
        this.queryParameters.put(name, Arrays.asList(value));
    }

    public void addQueryParameter(String name, String value) {
        List<String> values = this.queryParameters.get(name);
        if (values == null) {
            values = new LinkedList<String>();
            this.queryParameters.put(name, values);
        }
        values.add(value);
    }

    public void removeQueryParameter(String name) {
        this.queryParameters.remove(name);
    }

    public String toString() {
        return new ObjectToString(RestRequest.class).addProperty("connectTimeout", (Object)this.connectTimeout).addProperty("readTimeout", (Object)this.readTimeout).addProperty("method", (Object)this.method).addProperty("url", (Object)this.url).addProperty("headers", this.headers).addProperty("queryParameters", this.queryParameters).addPropertyLength("body", this.body).generateString();
    }

    public static RestRequest get(String url) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(METHOD_GET);
        restRequest.setUrl(url);
        return restRequest;
    }

    public static RestRequest head(String url) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(METHOD_HEAD);
        restRequest.setUrl(url);
        return restRequest;
    }

    public static RestRequest post(String url) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(METHOD_POST);
        restRequest.setUrl(url);
        return restRequest;
    }

    public static RestRequest put(String url) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(METHOD_PUT);
        restRequest.setUrl(url);
        return restRequest;
    }

    public static RestRequest delete(String url) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(METHOD_DELETE);
        restRequest.setUrl(url);
        return restRequest;
    }

    public static RestRequest connect(String url) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(METHOD_CONNECT);
        restRequest.setUrl(url);
        return restRequest;
    }

    public static RestRequest options(String url) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(METHOD_OPTIONS);
        restRequest.setUrl(url);
        return restRequest;
    }

    public static RestRequest trace(String url) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(METHOD_TRACE);
        restRequest.setUrl(url);
        return restRequest;
    }

    public static RestRequest patch(String url) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(METHOD_PATCH);
        restRequest.setUrl(url);
        return restRequest;
    }
}

