/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.activation.DataSource;

public class Attachment
implements Serializable,
DataSource {
    private static final long serialVersionUID = -7832925901202226810L;
    private String fileName;
    private String fileMimeType;
    private byte[] data;

    public Attachment() {
    }

    public Attachment(String fileName, String fileMimeType, byte[] data) {
        this.fileName = fileName;
        this.fileMimeType = fileMimeType;
        this.data = data;
    }

    public Attachment(String fileName, String fileMimeType, InputStream inputStream) throws IOException {
        this.fileName = fileName;
        this.fileMimeType = fileMimeType;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(131072);
        int n = inputStream.read();
        while (n >= 0) {
            byteArrayOutputStream.write(n);
            n = inputStream.read();
        }
        this.data = byteArrayOutputStream.toByteArray();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileMimeType() {
        return this.fileMimeType;
    }

    public void setFileMimeType(String fileMimeType) {
        this.fileMimeType = fileMimeType;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String getContentType() {
        return this.fileMimeType;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    public String getName() {
        return this.fileName;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Output stream not supported");
    }

    public String toString() {
        return "Attachment [fileName=" + this.fileName + ", fileMimeType=" + this.fileMimeType + ", data.length=" + this.data == null ? "null" : this.data.length + "]";
    }
}

