/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.jms;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import si.nevensrok.common.jms.JmsRequestor;
import si.nevensrok.common.jms.MessageCreator;
import si.nevensrok.common.utils.StringUtil;

public class JmsRequestorImpl
implements JmsRequestor,
MessageListener,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(JmsRequestorImpl.class);
    private ConnectionFactory connectionFactory;
    private String destination;
    private int deliveryMode = 1;
    private int priority = -1;
    private int timeToLive = -1;
    private int responseTimeout = -1;
    private boolean transacted = false;
    private int acknowledgeMode = 1;
    private MessageConverter messageConverter;
    private Connection connection;
    private Session session;
    private MessageProducer messageProducer;
    private TemporaryQueue responseDestination;
    private MessageConsumer responseConsumer;
    private Map<String, Message> messages = new HashMap<String, Message>();

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getConnectionFactory() == null) {
            throw new IllegalArgumentException("Property 'connectionFactory' is required");
        }
        if (this.getDestination() == null) {
            throw new IllegalArgumentException("Property 'destination' is required");
        }
        this.connection = this.getConnectionFactory().createConnection();
        this.connection.start();
        if (this.getMessageConverter() == null) {
            this.setMessageConverter((MessageConverter)new SimpleMessageConverter());
        }
        this.session = this.connection.createSession(this.isTransacted(), this.acknowledgeMode);
        Queue jmsDestination = this.session.createQueue(this.getDestination());
        this.messageProducer = this.session.createProducer((Destination)jmsDestination);
        this.messageProducer.setDeliveryMode(this.getDeliveryMode());
        if (this.getPriority() > 0) {
            this.messageProducer.setPriority(this.getPriority());
        }
        if (this.getTimeToLive() > 0) {
            this.messageProducer.setTimeToLive((long)this.getTimeToLive());
        }
        this.responseDestination = this.session.createTemporaryQueue();
        this.responseConsumer = this.session.createConsumer((Destination)this.responseDestination);
        this.responseConsumer.setMessageListener((MessageListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        try {
            this.responseConsumer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.responseDestination.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.messageProducer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map<String, Message> map = this.messages;
        synchronized (map) {
            this.messages.clear();
            this.messages.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message send(MessageCreator messageCreator) {
        String correlationId = UUID.randomUUID().toString();
        try {
            Map<String, Message> map = this.messages;
            synchronized (map) {
                this.messages.put(correlationId, null);
            }
            Message message = messageCreator.createMessage(this.session);
            message.setJMSReplyTo((Destination)this.responseDestination);
            message.setJMSCorrelationID(correlationId);
            log.trace("Sending message: {}", (Object)message);
            this.messageProducer.send(message);
            Message responseMessage = this.getMessage(correlationId);
            return responseMessage;
        }
        catch (Throwable e) {
            log.debug("Error sending message", e);
            this.clearMessageId(correlationId);
            throw new RuntimeException("Error while sending JMS message", e);
        }
    }

    @Override
    public <A, B> B send(A data) {
        try {
            final Message message = this.getMessageConverter().toMessage(data, this.session);
            Message responseMessage = this.send(new MessageCreator(){

                @Override
                public Message createMessage(Session session) throws JMSException {
                    return message;
                }
            });
            return (B)this.getMessageConverter().fromMessage(responseMessage);
        }
        catch (JMSException | MessageConversionException e) {
            log.debug("Error sending message", e);
            throw new RuntimeException("Error while sending JMS message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            log.trace("JMS message received: {}", (Object)message);
            String correlationId = message.getJMSCorrelationID();
            if (StringUtil.isEmpty((String)correlationId)) {
                throw new RuntimeException("CorrelationId not present");
            }
            Map<String, Message> map = this.messages;
            synchronized (map) {
                if (this.messages.containsKey(correlationId)) {
                    this.messages.put(correlationId, message);
                    this.messages.notifyAll();
                    return;
                }
            }
            log.warn("Discarding response message with CorrelationId [{}]", (Object)correlationId);
        }
        catch (Exception e) {
            log.debug("Error handling response message", (Throwable)e);
            throw new RuntimeException("Error handling message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearMessageId(String correlationId) {
        Map<String, Message> map = this.messages;
        synchronized (map) {
            this.messages.remove(correlationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message getMessage(String correlationId) {
        if (this.responseTimeout <= 0) {
            Map<String, Message> map = this.messages;
            synchronized (map) {
            }
        } else {
            long waitUntil = System.currentTimeMillis() + (long)this.responseTimeout;
            Map<String, Message> map = this.messages;
            synchronized (map) {
                while (true) {
                    if (this.messages.get(correlationId) != null) {
                        return this.messages.remove(correlationId);
                    }
                    if (!this.messages.containsKey(correlationId)) {
                        throw new RuntimeException("Request message was cleared");
                    }
                    long waitTime = waitUntil - System.currentTimeMillis();
                    if (waitTime <= 0L) {
                        throw new RuntimeException("Response timeout expired");
                    }
                    try {
                        this.messages.wait(waitTime);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        {
            while (this.messages.get(correlationId) == null) {
                if (!this.messages.containsKey(correlationId)) {
                    throw new RuntimeException("Request message was cleared");
                }
                try {
                    this.messages.wait();
                }
                catch (Exception exception) {
                }
            }
            return this.messages.remove(correlationId);
        }
    }
}

