/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.messagesource;

import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.core.io.Resource;
import si.nevensrok.common.messagesource.MessageLoader;
import si.nevensrok.common.utils.PlaceholderUtil;

public class ExternalMessageSource
implements MessageSource,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ExternalMessageSource.class);
    private boolean returnKeyIfMessageNotFound = true;
    private boolean overrideSavedValues = false;
    private MessageLoader messageLoader;
    private Map<Locale, Resource> initialMessages;
    private Locale defaultLocale;
    private String charset = "UTF8";

    public boolean isReturnKeyIfMessageNotFound() {
        return this.returnKeyIfMessageNotFound;
    }

    public void setReturnKeyIfMessageNotFound(boolean returnKeyIfMessageNotFound) {
        this.returnKeyIfMessageNotFound = returnKeyIfMessageNotFound;
    }

    public boolean isOverrideSavedValues() {
        return this.overrideSavedValues;
    }

    public void setOverrideSavedValues(boolean overrideSavedValues) {
        this.overrideSavedValues = overrideSavedValues;
    }

    public MessageLoader getMessageLoader() {
        return this.messageLoader;
    }

    public void setMessageLoader(MessageLoader messageLoader) {
        this.messageLoader = messageLoader;
    }

    public Map<Locale, Resource> getInitialMessages() {
        return this.initialMessages;
    }

    public void setInitialMessages(Map<Locale, Resource> initialMessages) {
        this.initialMessages = initialMessages;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.messageLoader == null) {
            throw new IllegalArgumentException("Property 'messageLoader' is requied");
        }
        if (this.defaultLocale == null) {
            throw new IllegalArgumentException("Property 'defaultLocale' is requied");
        }
        if (this.initialMessages != null) {
            for (Map.Entry<Locale, Resource> resourceEntry : this.initialMessages.entrySet()) {
                try {
                    Locale locale = resourceEntry.getKey();
                    Resource resource = resourceEntry.getValue();
                    log.debug("Loading initial messages for locale {}", (Object)locale);
                    Properties properties = new Properties();
                    properties.load(new InputStreamReader(resource.getInputStream(), this.charset));
                    for (Map.Entry<Object, Object> messageEntry : properties.entrySet()) {
                        String key = messageEntry.getKey().toString();
                        String message = messageEntry.getValue().toString();
                        if (!this.overrideSavedValues && this.messageLoader.isMessagePresent(locale, key)) continue;
                        this.messageLoader.setMessage(locale, key, message);
                    }
                }
                catch (Exception e) {
                    log.error("Error loading initial messages", (Throwable)e);
                }
            }
        }
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        String message;
        log.trace("Fetching message for code {} and locale {}", (Object)code, (Object)locale);
        if (locale == null) {
            locale = this.defaultLocale;
        }
        if ((message = this.loadMessage(code, locale)) == null) {
            if (defaultMessage != null) {
                message = defaultMessage;
            } else {
                if (this.returnKeyIfMessageNotFound) {
                    return "##" + code + "##";
                }
                throw new NoSuchMessageException(code, locale);
            }
        }
        message = this.replacePlaceholders(message, args);
        return message;
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getMessage(code, args, null, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        String defaultMessage = resolvable.getDefaultMessage();
        if ((resolvable.getCodes() == null || resolvable.getCodes().length == 0) && defaultMessage == null) {
            throw new IllegalArgumentException("Property resolvable.codes is null or empty");
        }
        Object[] args = resolvable.getArguments();
        if (resolvable.getCodes() != null) {
            for (String code : resolvable.getCodes()) {
                String message = this.loadMessage(code, locale);
                if (message == null) continue;
                message = this.replacePlaceholders(message, args);
                return message;
            }
        }
        if (defaultMessage != null) {
            defaultMessage = this.replacePlaceholders(defaultMessage, args);
            return defaultMessage;
        }
        StringBuilder messageCodesText = new StringBuilder();
        messageCodesText.append("[");
        for (String code : resolvable.getCodes()) {
            if (messageCodesText.length() > 1) {
                messageCodesText.append(", ");
            }
            messageCodesText.append(code);
        }
        messageCodesText.append("]");
        throw new NoSuchMessageException(messageCodesText.toString(), locale);
    }

    private String loadMessage(String code, Locale locale) {
        String message = this.messageLoader.getMessage(locale, code);
        if (message == null && locale.getVariant() != null && !locale.getVariant().isEmpty()) {
            message = this.messageLoader.getMessage(new Locale(locale.getLanguage(), locale.getCountry()), code);
        }
        if (message == null && locale.getCountry() != null && !locale.getCountry().isEmpty()) {
            message = this.messageLoader.getMessage(new Locale(locale.getLanguage()), code);
        }
        if (message == null) {
            message = this.messageLoader.getMessage(this.defaultLocale, code);
        }
        return message;
    }

    private String replacePlaceholders(String message, Object[] args) {
        if (args != null && args.length > 0) {
            LinkedHashMap<String, String> placeholders = new LinkedHashMap<String, String>();
            for (int i = 0; i < args.length; ++i) {
                placeholders.put(String.valueOf(i), args[i].toString());
            }
            message = PlaceholderUtil.replacePlaceHolders((String)message, placeholders, (String)"{", (String)"}");
        }
        return message;
    }
}

