/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.velocity;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.VelocimacroFactory;
import org.apache.velocity.runtime.directive.Break;
import org.apache.velocity.runtime.directive.Define;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.Evaluate;
import org.apache.velocity.runtime.directive.Foreach;
import org.apache.velocity.runtime.directive.Include;
import org.apache.velocity.runtime.directive.Literal;
import org.apache.velocity.runtime.directive.Macro;
import org.apache.velocity.runtime.directive.Parse;
import org.apache.velocity.runtime.directive.Stop;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.resource.ContentResource;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.introspection.Introspector;
import org.apache.velocity.util.introspection.Uberspect;
import org.apache.velocity.util.introspection.UberspectImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.velocity.ClasspathResourceLoader;
import si.nevensrok.common.velocity.VelocityLogger;

public class VelocityRuntimeServices
implements RuntimeServices {
    private static final Logger log = LoggerFactory.getLogger(VelocityRuntimeServices.class);
    private Log velocityLog = new Log((LogChute)new VelocityLogger());
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private Map<String, Object> configuration = new LinkedHashMap<String, Object>();
    private Map<Object, Object> applicationAttributes = new LinkedHashMap<Object, Object>();
    private String defaultEncoding = "UTF8";
    private ResourceLoader[] resourceLoaders;
    private VelocimacroFactory vmFactory = null;
    private Uberspect uberspect;
    private EventCartridge eventCartridge;
    private Introspector introspector;
    private Map<String, Directive> directives = new LinkedHashMap<String, Directive>();
    private Map<String, Resource> resourceCache = new LinkedHashMap<String, Resource>();
    private ClasspathResourceLoader globalMacroResourceLoader = new ClasspathResourceLoader();

    public VelocityRuntimeServices() {
        this.globalMacroResourceLoader.setResourcePath("/si/nevensrok/common/velocity");
        this.configuration.put("directive.foreach.counter.name", "velocityCount");
        this.configuration.put("directive.foreach.counter.initial.value", 1);
        this.configuration.put("directive.foreach.maxloops", -1);
        this.configuration.put("directive.foreach.iterator.name", "velocityHasNext");
        this.configuration.put("directive.set.null.allowed", Boolean.FALSE);
        this.configuration.put("directive.if.tostring.nullcheck", Boolean.TRUE);
        this.configuration.put("directive.include.output.errormsg.start", "<!-- include error :");
        this.configuration.put("directive.include.output.errormsg.end", "see error log -->");
        this.configuration.put("directive.parse.max.depth", 10);
        this.configuration.put("foreach.provide.scope.control", Boolean.TRUE);
        this.configuration.put("velocimacro.permissions.allow.inline", Boolean.TRUE);
        this.configuration.put("velocimacro.permissions.allow.inline.to.replace.global", Boolean.TRUE);
        this.configuration.put("velocimacro.permissions.allow.inline.local.scope", Boolean.FALSE);
        this.configuration.put("velocimacro.context.localscope", Boolean.FALSE);
        this.configuration.put("velocimacro.max.depth", 20);
        this.configuration.put("velocimacro.arguments.strict", Boolean.FALSE);
        this.configuration.put("velocimacro.body.reference", "bodyContent");
        this.configuration.put("velocimacro.library.autoreload", Boolean.TRUE);
        this.configuration.put("runtime.references.strict", Boolean.FALSE);
        this.configuration.put("runtime.interpolate.string.literals", Boolean.TRUE);
        this.vmFactory = new VelocimacroFactory((RuntimeServices)this);
        this.vmFactory.initVelocimacro();
        this.uberspect = new UberspectImpl();
        ((UberspectImpl)this.uberspect).setLog(this.getLog());
        ((UberspectImpl)this.uberspect).init();
        this.eventCartridge = new EventCartridge();
        try {
            this.eventCartridge.initialize((RuntimeServices)this);
        }
        catch (Exception e) {
            log.error("Error initializing event cartridge", (Throwable)e);
        }
        this.introspector = new Introspector(this.getLog());
        this.addDirective((Directive)new Foreach());
        this.addDirective((Directive)new Include());
        this.addDirective((Directive)new Parse());
        this.addDirective((Directive)new Macro());
        this.addDirective((Directive)new Literal());
        this.addDirective((Directive)new Evaluate());
        this.addDirective((Directive)new Break());
        this.addDirective((Directive)new Define());
        this.addDirective((Directive)new Stop());
    }

    private void addDirective(Directive directive) {
        this.directives.put(directive.getName(), directive);
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public ResourceLoader[] getResourceLoaders() {
        return this.resourceLoaders;
    }

    public void setResourceLoaders(ResourceLoader[] resourceLoaders) {
        this.resourceLoaders = resourceLoaders;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoaders = new ResourceLoader[]{resourceLoader};
    }

    public void warn(Object message) {
        log.warn(String.valueOf(message));
    }

    public void info(Object message) {
        log.info(String.valueOf(message));
    }

    public void error(Object message) {
        log.error(String.valueOf(message));
    }

    public void debug(Object message) {
        log.debug(String.valueOf(message));
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, Object value) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.properties.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(ExtendedProperties configuration) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            for (Object obj : configuration.entrySet()) {
                Map.Entry entry = (Map.Entry)obj;
                this.properties.put(String.valueOf(entry.getKey()), entry.getValue());
            }
        }
    }

    public void addProperty(String key, Object value) {
        this.setProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProperty(String key) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.properties.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String key) {
        Object value = null;
        Map<String, Object> map = this.properties;
        synchronized (map) {
            value = this.properties.get(key);
        }
        if (value == null) {
            map = this.configuration;
            synchronized (map) {
                value = this.configuration.get(key);
            }
        }
        if (value instanceof String) {
            value = ((String)value).trim();
        }
        return value;
    }

    public void init(Properties p) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            this.properties.put(String.valueOf(entry.getKey()), entry.getValue());
        }
    }

    public void init(String configurationFile) {
        try {
            this.setConfiguration(new ExtendedProperties(configurationFile));
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading properties from '" + configurationFile + "'", e);
        }
    }

    public SimpleNode parse(String string, String templateName) throws ParseException {
        return this.parse(new StringReader(string), templateName);
    }

    public SimpleNode parse(Reader reader, String templateName) throws ParseException {
        return this.parse(reader, templateName, true);
    }

    public SimpleNode parse(Reader reader, String templateName, boolean dumpNamespace) throws ParseException {
        Parser parser = new Parser((RuntimeServices)this);
        return parser.parse(reader, templateName);
    }

    public boolean evaluate(Context context, Writer out, String logTag, String instring) {
        return this.evaluate(context, out, logTag, new StringReader(instring));
    }

    public boolean evaluate(Context context, Writer writer, String logTag, Reader reader) {
        if (logTag == null) {
            throw new NullPointerException("logTag (i.e. template name) cannot be null, you must provide an identifier for the content being evaluated");
        }
        SimpleNode nodeTree = null;
        try {
            nodeTree = this.parse(reader, logTag);
        }
        catch (ParseException e) {
            throw new ParseErrorException(e, null);
        }
        catch (TemplateInitException e) {
            throw new ParseErrorException((VelocityException)e, null);
        }
        if (nodeTree == null) {
            return false;
        }
        return this.render(context, writer, logTag, nodeTree);
    }

    public boolean invokeVelocimacro(String vmName, String logTag, String[] params, Context context, Writer writer) {
        if (vmName == null || context == null || writer == null) {
            String msg = "RuntimeInstance.invokeVelocimacro() : invalid call : vmName, context, and writer must not be null";
            this.getLog().error((Object)msg);
            throw new NullPointerException(msg);
        }
        if (logTag == null) {
            logTag = vmName;
        }
        if (params == null) {
            params = new String[]{};
        }
        if (!this.isVelocimacro(vmName, logTag)) {
            String msg = "RuntimeInstance.invokeVelocimacro() : VM '" + vmName + "' is not registered.";
            this.getLog().error((Object)msg);
            throw new VelocityException(msg);
        }
        StringBuilder template = new StringBuilder("#");
        template.append(vmName);
        template.append("(");
        for (int i = 0; i < params.length; ++i) {
            template.append(" $");
            template.append(params[i]);
        }
        template.append(" )");
        return this.evaluate(context, writer, logTag, template.toString());
    }

    public Template getTemplate(String name) throws ResourceNotFoundException, ParseErrorException {
        return this.getTemplate(name, this.getDefaultEncoding());
    }

    public Template getTemplate(String name, String encoding) throws ResourceNotFoundException, ParseErrorException {
        Template template = (Template)this.getResource(name, encoding, 1);
        return template;
    }

    public ContentResource getContent(String name) throws ResourceNotFoundException, ParseErrorException {
        return this.getContent(name, this.getDefaultEncoding());
    }

    public ContentResource getContent(String name, String encoding) throws ResourceNotFoundException, ParseErrorException {
        ContentResource contentResource = (ContentResource)this.getResource(name, encoding, 2);
        return contentResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(String name, String encoding, int type) {
        Resource resource;
        Map<String, Resource> object = this.resourceCache;
        synchronized (object) {
            resource = this.resourceCache.get(name);
        }
        if (resource != null && resource.requiresChecking() && resource.isSourceModified()) {
            resource = null;
            Map<String, Resource> map = this.resourceCache;
            synchronized (map) {
                this.resourceCache.remove(name);
            }
        }
        if (resource == null) {
            if (name.equals("VM_global_library.vm") && (resource = this.loadResource(name, encoding, type, this.globalMacroResourceLoader)) != null) {
                return resource;
            }
            for (ResourceLoader resourceLoader : this.getResourceLoaders()) {
                resource = this.loadResource(name, encoding, type, resourceLoader);
                if (resource == null) continue;
                return resource;
            }
        } else {
            resource.touch();
            return resource;
        }
        throw new ResourceNotFoundException("Resource for name '" + name + "' not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource loadResource(String name, String encoding, int type, ResourceLoader resourceLoader) {
        Template resource;
        if (type == 1) {
            resource = new Template();
        } else if (type == 2) {
            resource = new ContentResource();
        } else {
            throw new ResourceNotFoundException("Invalid resource type " + type);
        }
        resource.setRuntimeServices((RuntimeServices)this);
        resource.setName(name);
        resource.setEncoding(encoding);
        resource.setResourceLoader(resourceLoader);
        try {
            if (!resource.process()) {
                return null;
            }
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
        long templateLastModified = resourceLoader.getLastModified((Resource)resource);
        if (resource.getData() == null) {
            throw new ResourceNotFoundException("Unable to find content for resource " + name);
        }
        resource.setLastModified(templateLastModified);
        resource.setModificationCheckInterval(resourceLoader.getModificationCheckInterval());
        resource.touch();
        if (resourceLoader.isCachingOn()) {
            Map<String, Resource> map = this.resourceCache;
            synchronized (map) {
                this.resourceCache.put(name, (Resource)resource);
            }
        }
        return resource;
    }

    public String getLoaderNameForResource(String resourceName) {
        return "default";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, String defaultValue) {
        Object value = null;
        Map<String, Object> map = this.configuration;
        synchronized (map) {
            value = this.configuration.get(key);
        }
        if (value == null) {
            return defaultValue;
        }
        return String.valueOf(value).trim();
    }

    public Directive getVelocimacro(String vmName, String templateName) {
        return this.vmFactory.getVelocimacro(vmName, templateName);
    }

    public Directive getVelocimacro(String vmName, String templateName, String renderingTemplate) {
        return this.vmFactory.getVelocimacro(vmName, templateName, renderingTemplate);
    }

    public boolean addVelocimacro(String name, String macro, String[] argArray, String sourceTemplate) {
        return this.vmFactory.addVelocimacro(name.intern(), macro, argArray, sourceTemplate);
    }

    public boolean addVelocimacro(String name, Node macro, String[] argArray, String sourceTemplate) {
        return this.vmFactory.addVelocimacro(name.intern(), macro, argArray, sourceTemplate);
    }

    public boolean isVelocimacro(String vmName, String templateName) {
        return this.vmFactory.isVelocimacro(vmName.intern(), templateName);
    }

    public boolean dumpVMNamespace(String namespace) {
        return this.vmFactory.dumpVMNamespace(namespace);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        String value = this.getString(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public boolean getBoolean(String key, boolean def) {
        String value = this.getString(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedProperties getConfiguration() {
        ExtendedProperties extendedProperties = new ExtendedProperties();
        Map<String, Object> map = this.configuration;
        synchronized (map) {
            for (Map.Entry<String, Object> entry : this.configuration.entrySet()) {
                extendedProperties.put((Object)entry.getKey(), entry.getValue());
            }
        }
        return extendedProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getApplicationAttribute(Object key) {
        Map<Object, Object> map = this.applicationAttributes;
        synchronized (map) {
            return this.applicationAttributes.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setApplicationAttribute(Object key, Object value) {
        Map<Object, Object> map = this.applicationAttributes;
        synchronized (map) {
            Object oldValue = this.applicationAttributes.get(key);
            this.applicationAttributes.put(key, value);
            return oldValue;
        }
    }

    public Uberspect getUberspect() {
        return this.uberspect;
    }

    public Log getLog() {
        return this.velocityLog;
    }

    public EventCartridge getApplicationEventCartridge() {
        return this.eventCartridge;
    }

    public Introspector getIntrospector() {
        return this.introspector;
    }

    public boolean isInitialized() {
        return true;
    }

    public Parser createNewParser() {
        Parser parser = new Parser((RuntimeServices)this);
        return parser;
    }

    public Directive getDirective(String name) {
        return this.directives.get(name);
    }

    public boolean render(Context context, Writer writer, String logTag, SimpleNode nodeTree) {
        InternalContextAdapterImpl contextAdapterImpl = new InternalContextAdapterImpl(context);
        contextAdapterImpl.pushCurrentTemplateName(logTag);
        try {
            nodeTree.init((InternalContextAdapter)contextAdapterImpl, (Object)this);
        }
        catch (TemplateInitException pex) {
            throw new ParseErrorException((VelocityException)pex, null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "RuntimeInstance.render(): init exception for tag = " + logTag;
            this.getLog().error((Object)msg, (Throwable)e);
            throw new VelocityException(msg, (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResourceCache() {
        Map<String, Resource> map = this.resourceCache;
        synchronized (map) {
            this.resourceCache.clear();
        }
    }
}

