/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.udp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.network.udp.UdpNetworkClient;
import si.nevensrok.common.utils.MachineInfoUtil;
import si.nevensrok.common.utils.ObjectUtil;

public class UdpBroadcastMessageSenderAndReceiver
extends UdpNetworkClient {
    private static final Logger log = LoggerFactory.getLogger(UdpBroadcastMessageSenderAndReceiver.class);
    private String[] devices = null;
    private String[] addresses;

    @Override
    public void setAddress(String address) {
        this.addresses = new String[]{address};
    }

    public void setAddresses(String[] addresses) {
        this.addresses = addresses;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public String[] getDevices() {
        return this.devices;
    }

    public void setDevices(String[] devices) {
        this.devices = devices;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.getAddresses() == null) {
            LinkedList<String> addressList = new LinkedList<String>();
            for (NetworkInterface networkInterface : MachineInfoUtil.getActiveNetworkInterfaces()) {
                if (!this.isDeviceOnList(networkInterface.getName(), networkInterface.getInterfaceAddresses())) continue;
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    InetAddress broadcastAddress = interfaceAddress.getBroadcast();
                    if (broadcastAddress == null) continue;
                    addressList.add(broadcastAddress.getHostAddress());
                }
            }
            this.setAddresses(addressList.toArray(new String[addressList.size()]));
        }
    }

    @Override
    public void sendMessage(Object object) throws NetworkException {
        if (this.getPort() == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        this.sendMessage((int)this.getPort(), object);
    }

    @Override
    public void sendMessage(byte[] data) throws NetworkException {
        if (this.getPort() == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        this.sendMessage((int)this.getPort(), data);
    }

    @Override
    public void sendMessage(int port, Object object) throws NetworkException {
        try {
            byte[] data = ObjectUtil.serializeObject((Object)object);
            this.sendMessage(port, data);
        }
        catch (NetworkException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NetworkException("Error sending message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(int port, byte[] data) throws NetworkException {
        if (this.socket == null) {
            throw new NetworkException("Socket is closed");
        }
        for (String address : this.getAddresses()) {
            try {
                DatagramPacket packet = this.generateDatagramPacket(address, port, data);
                if (log.isTraceEnabled()) {
                    log.trace("Sending message to [{}]:{}, message data: {}", new Object[]{address, port, data});
                }
                Object object = this.senderMonitor;
                synchronized (object) {
                    this.socket.send(packet);
                }
            }
            catch (Exception e) {
                throw new NetworkException("Error sending message", e);
            }
        }
    }

    private boolean isDeviceOnList(String name, List<InterfaceAddress> addressList) {
        if (this.devices == null) {
            return true;
        }
        for (String device : this.devices) {
            if (device.equalsIgnoreCase(name)) {
                return true;
            }
            for (InterfaceAddress interfaceAddress : addressList) {
                if (interfaceAddress.getAddress() == null || !device.equalsIgnoreCase(interfaceAddress.getAddress().getHostAddress())) continue;
                return true;
            }
        }
        return false;
    }
}

