/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.tcp;

import java.io.Closeable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.network.tcp.ConnectionEstablishedHandler;
import si.nevensrok.common.network.tcp.DisconnectListener;
import si.nevensrok.common.network.tcp.TcpNetworkConnection;
import si.nevensrok.common.utils.CloseUtil;

public class TcpNetworkServer
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TcpNetworkServer.class);
    private Integer port;
    private String address;
    private ConnectionEstablishedHandler connectionEstablishedHandler = null;
    private int maxConnections = -1;
    private int queueSize = -1;
    private int maxMessageSize = 0x10000000;
    private int chunkSize = 0x200000;
    private boolean threadDaemon = true;
    private boolean active = false;
    private ServerSocket serverSocket = null;
    private final Set<TcpNetworkConnection> openTcpNetworkConnections = new LinkedHashSet<TcpNetworkConnection>();

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public ConnectionEstablishedHandler getConnectionEstablishedHandler() {
        return this.connectionEstablishedHandler;
    }

    public void setConnectionEstablishedHandler(ConnectionEstablishedHandler connectionEstablishedHandler) {
        this.connectionEstablishedHandler = connectionEstablishedHandler;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public boolean isThreadDaemon() {
        return this.threadDaemon;
    }

    public void setThreadDaemon(boolean threadDaemon) {
        this.threadDaemon = threadDaemon;
    }

    public int getLocalPort() {
        if (!this.active) {
            throw new IllegalStateException("Tcp network server is not active");
        }
        return this.serverSocket.getLocalPort();
    }

    public int getCurrentConnectionCount() {
        return this.openTcpNetworkConnections.size();
    }

    protected ServerSocket openSocket() throws Exception {
        if (this.getPort() == null || this.getPort() < 1) {
            return new ServerSocket(0);
        }
        if (this.getAddress() != null) {
            InetAddress inetAddress = InetAddress.getByName(this.getAddress());
            return new ServerSocket(this.getPort(), 50, inetAddress);
        }
        return new ServerSocket(this.getPort());
    }

    protected TcpNetworkConnection openTcpNetworkConnection(Socket socket) throws Exception {
        return new TcpNetworkConnection(socket);
    }

    protected String getServerName() {
        StringBuilder connectionName = new StringBuilder();
        connectionName.append("[");
        if (this.getAddress() != null) {
            connectionName.append(this.getAddress());
        } else {
            connectionName.append("::");
        }
        connectionName.append("]:");
        if (this.serverSocket != null) {
            connectionName.append(this.serverSocket.getLocalPort());
        } else if (this.getPort() != null) {
            connectionName.append(this.getPort());
        } else {
            connectionName.append("0");
        }
        return connectionName.toString();
    }

    public void afterPropertiesSet() throws Exception {
        this.serverSocket = this.openSocket();
        this.active = true;
        String serverName = this.getServerName();
        log.debug("Started TCP network server on {}", (Object)serverName);
        Thread connectionThread = new Thread("Server connection thread for " + serverName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (TcpNetworkServer.this.active) {
                    Socket socket = null;
                    try {
                        socket = TcpNetworkServer.this.serverSocket.accept();
                        Set set = TcpNetworkServer.this.openTcpNetworkConnections;
                        synchronized (set) {
                            if (!TcpNetworkServer.this.active) {
                                CloseUtil.close((Closeable[])new Closeable[]{socket});
                                return;
                            }
                            if (TcpNetworkServer.this.maxConnections > 0 && TcpNetworkServer.this.openTcpNetworkConnections.size() >= TcpNetworkServer.this.maxConnections) {
                                CloseUtil.close((Closeable[])new Closeable[]{socket});
                                continue;
                            }
                            TcpNetworkServer.this.startTcpNetworkConnection(socket);
                        }
                    }
                    catch (Throwable e) {
                        log.trace("Error accepting connection", e);
                        CloseUtil.close((Closeable[])new Closeable[]{socket});
                    }
                }
            }
        };
        connectionThread.setDaemon(this.isThreadDaemon());
        connectionThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        this.active = false;
        CloseUtil.close((Closeable[])new Closeable[]{this.serverSocket});
        this.serverSocket = null;
        Set<TcpNetworkConnection> set = this.openTcpNetworkConnections;
        synchronized (set) {
            for (TcpNetworkConnection tcpNetworkConnection : new LinkedList<TcpNetworkConnection>(this.openTcpNetworkConnections)) {
                CloseUtil.close((Closeable[])new Closeable[]{tcpNetworkConnection});
            }
            this.openTcpNetworkConnections.clear();
        }
    }

    private void startTcpNetworkConnection(Socket socket) {
        try {
            TcpNetworkConnection tcpNetworkConnection = this.openTcpNetworkConnection(socket);
            if (this.connectionEstablishedHandler != null) {
                this.connectionEstablishedHandler.connectionAccepted(tcpNetworkConnection);
            }
            tcpNetworkConnection.setDisconnectListener(new DisconnectListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void disconnected(TcpNetworkConnection tcpNetworkConnection) {
                    Set set = TcpNetworkServer.this.openTcpNetworkConnections;
                    synchronized (set) {
                        TcpNetworkServer.this.openTcpNetworkConnections.remove(tcpNetworkConnection);
                    }
                }
            });
            tcpNetworkConnection.setMaxMessageSize(this.getMaxMessageSize());
            tcpNetworkConnection.setChunkSize(this.getChunkSize());
            tcpNetworkConnection.open();
            this.openTcpNetworkConnections.add(tcpNetworkConnection);
        }
        catch (Throwable e) {
            log.trace("Error starting tcp connection", e);
            CloseUtil.close((Closeable[])new Closeable[]{socket});
        }
    }
}

