/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.streams;

import java.io.IOException;
import java.io.OutputStream;
import si.nevensrok.common.encryption.Encryptor;

public class EncryptedOutputStream
extends OutputStream {
    private OutputStream outputStream;
    private Encryptor encryptor;
    private boolean closed = false;
    private byte[] buffer;
    private int bufferPos = 0;

    public EncryptedOutputStream(OutputStream outputStream, Encryptor encryptor, int bufferSize) {
        this.outputStream = outputStream;
        this.encryptor = encryptor;
        this.buffer = new byte[bufferSize];
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.buffer[this.bufferPos] = (byte)b;
        ++this.bufferPos;
        if (this.bufferPos >= this.buffer.length) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.buffer.length - this.bufferPos >= len) {
            System.arraycopy(b, off, this.buffer, this.bufferPos, len);
            this.bufferPos += len;
        } else {
            int bytesToWrite;
            for (int bytesWritten = 0; bytesWritten < len; bytesWritten += bytesToWrite) {
                if (this.bufferPos >= this.buffer.length) {
                    this.flush();
                }
                bytesToWrite = Math.min(this.buffer.length - this.bufferPos, len - bytesWritten);
                System.arraycopy(b, off + bytesWritten, this.buffer, this.bufferPos, bytesToWrite);
                this.bufferPos += bytesToWrite;
            }
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.bufferPos == 0) {
            return;
        }
        byte[] data = new byte[this.bufferPos];
        System.arraycopy(this.buffer, 0, data, 0, this.bufferPos);
        this.bufferPos = 0;
        data = this.encryptor.encrypt(data);
        this.writeLength(data.length);
        this.outputStream.write(data);
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.closed = true;
        this.outputStream.close();
    }

    private void writeLength(int length) throws IOException {
        this.outputStream.write(length);
        this.outputStream.write(length >> 8 & 0xFF);
        this.outputStream.write(length >> 16 & 0xFF);
        this.outputStream.write(length >> 24 & 0xFF);
    }
}

