/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static <T> Map<Class<?>, T> getClassesForAnnotation(Class<?> clazz, Class<T> annotationClass) {
        LinkedHashMap classesForAnnotation = new LinkedHashMap();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Annotation annotation : currentClass.getAnnotations()) {
                if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
                classesForAnnotation.put(currentClass, annotation);
            }
        }
        return classesForAnnotation;
    }

    public static <T> Map<Field, T> getFieldsForAnnotation(Class<?> clazz, Class<T> annotationClass) {
        LinkedHashMap<Field, Annotation> fieldsForAnnotation = new LinkedHashMap<Field, Annotation>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                for (Annotation annotation : field.getAnnotations()) {
                    if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
                    fieldsForAnnotation.put(field, annotation);
                }
            }
        }
        return fieldsForAnnotation;
    }

    public static <T> Map<Method, T> getMethodsForAnnotation(Class<?> clazz, Class<T> annotationClass) {
        LinkedHashMap<Method, Annotation> methodsForAnnotation = new LinkedHashMap<Method, Annotation>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Method method : currentClass.getDeclaredMethods()) {
                for (Annotation annotation : method.getAnnotations()) {
                    if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
                    methodsForAnnotation.put(method, annotation);
                }
            }
        }
        return methodsForAnnotation;
    }

    public static Method findMethod(Class<?> clazz, String methodName, Class<?>[] methodParameterTypes) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Method method : currentClass.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || !Arrays.equals(method.getParameterTypes(), methodParameterTypes)) continue;
                return method;
            }
        }
        return null;
    }

    public static Field getFieldByName(Class<?> clazz, String fieldName) {
        Class<?> classToCheck = clazz;
        while (!classToCheck.equals(Object.class)) {
            for (Field field : classToCheck.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
            classToCheck = classToCheck.getSuperclass();
        }
        return null;
    }

    public static Method findGetterMethod(Field field) {
        return ClassUtil.findGetterMethod(field.getDeclaringClass(), field.getName(), field.getType());
    }

    public static Method findGetterMethod(Class<?> clazz, String fieldName) {
        return ClassUtil.findGetterMethod(clazz, fieldName, null);
    }

    public static Method findGetterMethod(Class<?> clazz, String fieldName, Class<?> fieldType) {
        String methodName = "get" + fieldName;
        String alternativeName = null;
        if (fieldType == null || Boolean.TYPE.equals(fieldType)) {
            alternativeName = "is" + fieldName;
        }
        for (Method method : clazz.getMethods()) {
            if (method.getParameterTypes().length != 0 || !method.getName().equalsIgnoreCase(methodName) && (alternativeName == null || !method.getName().equalsIgnoreCase(alternativeName)) || fieldType != null && !method.getReturnType().isAssignableFrom(fieldType)) continue;
            return method;
        }
        return null;
    }

    public static Method findSetterMethod(Field field) {
        return ClassUtil.findSetterMethod(field.getDeclaringClass(), field.getName(), field.getType());
    }

    public static Method findSetterMethod(Class<?> clazz, String fieldName) {
        return ClassUtil.findSetterMethod(clazz, fieldName, null);
    }

    public static Method findSetterMethod(Class<?> clazz, String fieldName, Class<?> fieldType) {
        String methodName = "set" + fieldName;
        for (Method method : clazz.getMethods()) {
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 1 || fieldType != null && !parameters[0].isAssignableFrom(fieldType) || !method.getName().equalsIgnoreCase(methodName)) continue;
            return method;
        }
        return null;
    }

    public static String generateMethodSignature(Method method) {
        StringBuilder methodSignature = new StringBuilder();
        methodSignature.append(method.getName());
        methodSignature.append("(");
        boolean firstParameter = true;
        for (Class<?> clazz : method.getParameterTypes()) {
            if (firstParameter) {
                firstParameter = false;
            } else {
                methodSignature.append(", ");
            }
            methodSignature.append(clazz.getName());
        }
        methodSignature.append(")");
        return methodSignature.toString();
    }
}

