/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTrustStore {
    private static final Logger log = LoggerFactory.getLogger(SystemTrustStore.class);
    private static KeyStore trustStore;

    public static KeyStore getSystemTrustStore() {
        return trustStore;
    }

    static {
        InputStream inputStream = null;
        try {
            File file = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts");
            inputStream = new FileInputStream(file);
            trustStore = KeyStore.getInstance("JKS");
            trustStore.load(inputStream, "changeit".toCharArray());
        }
        catch (Exception e) {
            log.error("Error loading system truststore", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }
}

