/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.tcp;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.NetworkMessageHandler;
import si.nevensrok.common.network.NetworkMessenger;
import si.nevensrok.common.network.streams.StreamSplitter;
import si.nevensrok.common.network.tcp.DisconnectListener;
import si.nevensrok.common.utils.CloseUtil;
import si.nevensrok.common.utils.ObjectUtil;

public class TcpNetworkConnection
implements NetworkMessenger,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpNetworkConnection.class);
    private boolean active = true;
    private Socket socket;
    private InputStream socketInputStream;
    private OutputStream socketOutputStream;
    private OutputStream outputStream;
    private InputStream inputStream;
    private StreamSplitter streamSplitter;
    private final Object connectedMonitor = new Object();
    private NetworkMessageHandler networkMessageHandler;
    private Executor executor;
    private int maxMessageSize = 0x10000000;
    private int chunkSize = 0x200000;
    private DisconnectListener disconnectListener = null;

    protected TcpNetworkConnection(Socket socket) throws Exception {
        this.socket = socket;
    }

    protected TcpNetworkConnection(Socket socket, InputStream inputStream, OutputStream outputStream) throws Exception {
        this.socket = socket;
        this.socketInputStream = inputStream;
        this.socketOutputStream = outputStream;
    }

    public void setDisconnectListener(DisconnectListener disconnectListener) {
        this.disconnectListener = disconnectListener;
    }

    protected OutputStream openOutputStream(OutputStream outputStream) throws Exception {
        return outputStream;
    }

    protected InputStream openInputStream(InputStream inputStream) throws Exception {
        return inputStream;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() throws Exception {
        try {
            if (this.socketOutputStream == null) {
                this.socketOutputStream = this.socket.getOutputStream();
            }
            if (this.socketInputStream == null) {
                this.socketInputStream = this.socket.getInputStream();
            }
            this.outputStream = this.openOutputStream(this.socketOutputStream);
            this.outputStream.flush();
            this.inputStream = this.openInputStream(this.socketInputStream);
            this.streamSplitter = new StreamSplitter(this.outputStream, this.inputStream, this.getMaxMessageSize(), this.getChunkSize());
            Object object = this.connectedMonitor;
            synchronized (object) {
                this.connectedMonitor.notifyAll();
            }
            Thread readerThread = new Thread("Tcp connection reader thread for socket [" + this.socket.getLocalAddress().getHostAddress() + "]:" + this.socket.getLocalPort()){

                @Override
                public void run() {
                    while (TcpNetworkConnection.this.active) {
                        try {
                            byte[] data = TcpNetworkConnection.this.streamSplitter.readData();
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace("Read bytes: {}", new Object[]{data});
                            }
                            final NetworkMessage networkMessage = new NetworkMessage(TcpNetworkConnection.this.socket.getInetAddress(), TcpNetworkConnection.this.socket.getPort(), data);
                            if (TcpNetworkConnection.this.networkMessageHandler == null) continue;
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        TcpNetworkConnection.this.networkMessageHandler.handleMessage(networkMessage);
                                    }
                                    catch (Throwable e) {
                                        LOGGER.error("Error handling network message", e);
                                    }
                                }
                            };
                            if (TcpNetworkConnection.this.executor != null) {
                                TcpNetworkConnection.this.executor.execute(runnable);
                                continue;
                            }
                            runnable.run();
                        }
                        catch (Throwable e) {
                            LOGGER.trace("Error reading message", e);
                            TcpNetworkConnection.this.close();
                        }
                    }
                }
            };
            readerThread.setDaemon(true);
            readerThread.start();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void close() {
        if (!this.active) {
            return;
        }
        this.active = false;
        CloseUtil.close((Closeable[])new Closeable[]{this.outputStream, this.inputStream, this.socketInputStream, this.socketOutputStream, this.socket});
        if (this.disconnectListener != null) {
            this.disconnectListener.disconnected(this);
        }
    }

    @Override
    public void sendMessage(Object object) throws NetworkException {
        try {
            byte[] data = ObjectUtil.serializeObject((Object)object);
            this.sendMessage(data);
        }
        catch (NetworkException e) {
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new NetworkException("Error sending message", e);
        }
    }

    @Override
    public void sendMessage(byte[] data) throws NetworkException {
        if (!this.active) {
            throw new NetworkException("Connection is closed");
        }
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Sending bytes: {}", new Object[]{data});
            }
            this.streamSplitter.writeData(data);
        }
        catch (Throwable e) {
            this.close();
            throw new NetworkException("Error sending message", e);
        }
    }

    @Override
    public void setNetworkMessageHandler(NetworkMessageHandler networkMessageHandler) {
        this.networkMessageHandler = networkMessageHandler;
    }

    public boolean isConnectionEstablished() {
        return this.active && this.outputStream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForConnection(long waitTime) {
        if (!this.active) {
            return false;
        }
        if (waitTime > 0L) {
            long sleepTime;
            long waitUntil = System.currentTimeMillis() + waitTime;
            while (!this.isConnectionEstablished() && (sleepTime = waitUntil - System.currentTimeMillis()) > 0L) {
                Object object = this.connectedMonitor;
                synchronized (object) {
                    try {
                        this.connectedMonitor.wait(sleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.isConnectionEstablished();
    }

    public long getLastActivityAt() {
        if (this.streamSplitter != null) {
            return this.streamSplitter.getLastActivityAt();
        }
        return Long.MIN_VALUE;
    }

    public Socket getSocket() {
        return this.socket;
    }
}

